% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\docType{class}
\name{FastRGF_Regressor}
\alias{FastRGF_Regressor}
\title{A Fast Regularized Greedy Forest regressor}
\format{An object of class \code{R6ClassGenerator} of length 24.}
\usage{
# init <- FastRGF_Regressor$new(n_estimators = 500, max_depth = 6,
#                                      max_leaf = 50, tree_gain_ratio = 1.0,
#                                      min_samples_leaf = 5, l1 = 1.0,
#                                      l2 = 1000.0, opt_algorithm = "rgf",
#                                      learning_rate = 0.001, max_bin = NULL,
#                                      min_child_weight = 5.0, data_l2 = 2.0,
#                                      sparse_max_features = 80000,
#                                      sparse_min_occurences = 5,
#                                      n_jobs = 1, verbose = 0)
}
\arguments{
\item{x}{an R matrix (object) or a Python sparse matrix (object) of shape c(n_samples, n_features). The training input samples. The sparse matrix should be a Python sparse matrix. The helper functions \emph{mat_2scipy_sparse} and \emph{TO_scipy_sparse} allow the user to convert an R dense or sparse matrix to a scipy sparse matrix.}

\item{y}{a vector of shape c(n_samples). The target values (real numbers in regression).}

\item{n_estimators}{an integer. The number of trees in the forest (Original name: forest.ntrees.)}

\item{max_depth}{an integer. Maximum tree depth (Original name: dtree.max_level.)}

\item{max_leaf}{an integer. Maximum number of leaf nodes in best-first search (Original name: dtree.max_nodes.)}

\item{tree_gain_ratio}{a float. New tree is created when leaf-nodes gain < this value * estimated gain of creating new tree (Original name: dtree.new_tree_gain_ratio.)}

\item{min_samples_leaf}{an integer or float. Minimum number of training data points in each leaf node. If an integer, then consider min_samples_leaf as the minimum number. If a float, then min_samples_leaf is a percentage and ceil(min_samples_leaf * n_samples) are the minimum number of samples for each node (Original name: dtree.min_sample.)}

\item{l1}{a float. Used to control the degree of L1 regularization (Original name: dtree.lamL1.)}

\item{l2}{a float. Used to control the degree of L2 regularization (Original name: dtree.lamL2.)}

\item{opt_algorithm}{a character string. Either \emph{"rgf"} or \emph{"epsilon-greedy"}. Optimization method for training forest (Original name: forest.opt.)}

\item{learning_rate}{a float. Step size of epsilon-greedy boosting. Meant for being used with opt_algorithm = "epsilon-greedy" (Original name: forest.stepsize.)}

\item{max_bin}{an integer or NULL. Maximum number of discretized values (bins). If NULL, 65000 is used for dense data and 200 for sparse data (Original name: discretize.(sparse/dense).max_buckets.)}

\item{min_child_weight}{a float. Minimum sum of data weights for each discretized value (bin) (Original name: discretize.(sparse/dense).min_bucket_weights.)}

\item{data_l2}{a float. Used to control the degree of L2 regularization for discretization (Original name: discretize.(sparse/dense).lamL2.)}

\item{sparse_max_features}{an integer. Maximum number of selected features. Meant for being used with sparse data (Original name: discretize.sparse.max_features.)}

\item{sparse_min_occurences}{an integer. Minimum number of occurrences for a feature to be selected. Meant for being used with sparse data (Original name: discretize.sparse.min_occrrences.)}

\item{n_jobs}{an integer. The number of jobs to run in parallel for both fit and predict. If -1, all CPUs are used. If -2, all CPUs but one are used. If < -1, (n_cpus + 1 + n_jobs) are used (Original name: set.nthreads.)}

\item{verbose}{an integer. Controls the verbosity of the tree building process (Original name: set.verbose.)}
}
\description{
A Fast Regularized Greedy Forest regressor
}
\details{
the \emph{fit} function builds a regressor from the training set (x, y).

the \emph{predict} function predicts the regression target for x.

the \emph{cleanup} function removes tempfiles used by this model. See the issue \emph{https://github.com/fukatani/rgf_python/issues/75}, which explains in which cases the \emph{cleanup} function applies.

the \emph{get_params} function returns the parameters of the model.

the \emph{score} function returns the coefficient of determination ( R^2 ) for the predictions.
}
\section{Methods}{


\describe{
 \item{\code{FastRGF_Regressor$new(n_estimators = 500, max_depth = 6,
                                   max_leaf = 50, tree_gain_ratio = 1.0,
                                   min_samples_leaf = 5, l1 = 1.0,
                                   l2 = 1000.0, opt_algorithm = "rgf",
                                   learning_rate = 0.001, max_bin = NULL,
                                   min_child_weight = 5.0, data_l2 = 2.0,
                                   sparse_max_features = 80000,
                                   sparse_min_occurences = 5,
                                   n_jobs = 1, verbose = 0)}}{}

 \item{\code{--------------}}{}

 \item{\code{fit(x, y, sample_weight = NULL)}}{}

 \item{\code{--------------}}{}

 \item{\code{predict(x)}}{}

 \item{\code{--------------}}{}

 \item{\code{cleanup()}}{}

 \item{\code{--------------}}{}

 \item{\code{get_params(deep = TRUE)}}{}

 \item{\code{--------------}}{}

 \item{\code{score(x, y, sample_weight = NULL)}}{}
 }
}

\examples{

if (reticulate::py_available() && reticulate::py_module_available("rgf.sklearn")) {

  library(RGF)

  set.seed(1)
  x = matrix(runif(100000), nrow = 100, ncol = 1000)

  y = runif(100)

  fast_RGF_regr = FastRGF_Regressor$new(max_leaf = 50)

  fast_RGF_regr$fit(x, y)

  preds = fast_RGF_regr$predict(x)
}
}
\references{
\emph{https://github.com/fukatani/rgf_python}, \emph{Tong Zhang, FastRGF: Multi-core Implementation of Regularized Greedy Forest (https://github.com/baidu/fast_rgf)}
}
\keyword{datasets}
