% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batchTwoDCOW.R
\name{batch_2DCOW}
\alias{batch_2DCOW}
\title{Two-dimensional COW in batch.}
\usage{
batch_2DCOW(reference, sample_chroms, segments, max_warp, add_ref = FALSE)
}
\arguments{
\item{reference}{a GCxGC chromatogram which will be taken as the reference 
chromatogram.}

\item{sample_chroms}{a named list with the sample chromatograms which will
be aligned against to the reference chromatogram.}

\item{segments}{a two integer vector with the number of segments
which the first and second dimension will be divided, respectively.}

\item{max_warp}{a two integer vector with the maximum warping parameter for
the first and second dimension}

\item{add_ref}{a logical indicating if the reference chromatogram will
be joined together with the sample chromatograms. By the fault add_ref = F.
If add_ref is set to T, the provide reference chromatogram will 
be included as another sample chromatogram in the downstream analysis.}
}
\description{
`batch_2DCOW` perform two-dimensional correlation optimized warping
alignment in batch.
}
\details{
The first argument is the reference chromatogram which other chromatograms
will aligned against to. Then, a named list is needed for the sample_chroms
argument. Each chromatogram in this list will be aligned using the reference
chromatogram. By default, the reference chromatogram will be not included in
the subsequent analysis, such as MPCA. If you would like to add the reference
chromatogram, then add_ref = T.

This is an adaptation of two-dimensional COW alignment, firstly implemented
in MATLAB. This function takes a set of samples chromatogram to be aligned 
against to the reference. The argument [segment] will be used 
to split the whole chromatogram in \emph{n} and \emph{m} parts in the first
and the second dimension, respectively. The [max_warp] argument provides
the maximum tolerance of the signal transformation for the first and the
second dimension, respectively.
}
\examples{

# Read Sample chromatogram
GB08_fl <- system.file("extdata", "08GB.cdf", package = "RGCxGC")
MTBLS08 <- read_chrom(GB08_fl, mod_time = 5)

# Read reference chromatogram
GB09_fl <- system.file("extdata", "09GB.cdf", package = "RGCxGC")
MTBLS09 <- read_chrom(GB09_fl, mod_time = 5)

# Create a named list
# MTBLS08 will be repeated for exemplification
# Considerer that chromatograms are renamed considering the list names
batch_samples <- list(Chrom1 = MTBLS08, Chrom2 = MTBLS08)

\donttest{
# Perform batch 2DCOW alignment
# Add the reference chromatogram as another sample
batch_alignment <- batch_2DCOW(MTBLS09, batch_samples,
                               c(10, 40), c(1, 10), add_ref = TRUE)
# Exclude the reference chromatogram in the sample chromatogram set
batch_alignment <- batch_2DCOW(MTBLS09, batch_samples, c(10, 40), c(1, 10))
}

}
