% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.permutation.R
\name{print.permutation}
\alias{print.permutation}
\title{Print a rgcca_permutation object}
\usage{
\method{print}{permutation}(x, ...)
}
\arguments{
\item{x}{A fitted rgcca_permutation object (see
\code{\link[RGCCA]{rgcca_permutation}})}

\item{...}{Other parameters used in print (for the displaying of matrices).}
}
\value{
none
}
\description{
Print a fitted rgcca_permutation object. Parameters of the
analysis, tuning parameters and statistics for each set of
parameters are displayed.
}
\examples{
data(Russett)
A <- list(
  agriculture = Russett[, seq(3)],
  industry = Russett[, 4:5],
  politic = Russett[, 6:11]
)

perm.out <- rgcca_permutation(A,
  par_type = "tau",
  n_perms = 5, n_cores = 1,
  verbose = TRUE
)
print(perm.out)
}
