% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/webproperties.R
\name{get_webproperty}
\alias{get_webproperty}
\title{Gets a web property to which the user has access to}
\usage{
get_webproperty(account.id, webproperty.id, token)
}
\arguments{
\item{account.id}{integer or character. Account ID to retrieve the web property for.}

\item{webproperty.id}{character. ID to retrieve the web property for.}

\item{token}{\code{\link[httr]{Token2.0}} class object with a valid authorization data.}
}
\value{
An Analytics web property.
\item{id}{Web property ID of the form UA-XXXXX-YY.}
\item{kind}{Resource type for Analytics Web.property.}
\item{self.link}{Link for this web property.}
\item{account.id}{Account ID to which this web property belongs.}
\item{internal.web.property.id}{Internal ID for this web property.}
\item{name}{Name of this web property.}
\item{website.url}{Website url for this web property.}
\item{level}{Level for this web property.}
\item{profile.count}{View (Profile) count for this web property.}
\item{industry.vertical}{The industry vertical/category selected for this web property.}
\item{default.profile.id}{Default view (profile) ID.}
\item{permissions}{Permissions the user has for this web property.}
\item{created}{Time this web property was created.}
\item{updated}{Time this web property was last modified.}
\item{parent.link}{Parent link for this web property. Points to the account to which this web property belongs.}
\item{child.link}{Child link for this web property. Points to the list of views (profiles) for this web property.}
}
\description{
Gets a web property to which the user has access to
}
\references{
\href{https://developers.google.com/analytics/devguides/config/mgmt/v3/mgmtReference/management/webproperties}{Google Management API - Web Properties}
}
\seealso{
\code{\link{authorize}}

Other Management API: \code{\link{get_custom_dimension}};
  \code{\link{get_custom_metric}};
  \code{\link{get_experiment}}; \code{\link{get_filter}};
  \code{\link{get_goal}}; \code{\link{get_profile}};
  \code{\link{get_unsampled_report}};
  \code{\link{list_accounts}};
  \code{\link{list_custom_dimensions}};
  \code{\link{list_custom_metrics}};
  \code{\link{list_custom_sources}};
  \code{\link{list_experiments}};
  \code{\link{list_filters}}; \code{\link{list_goals}};
  \code{\link{list_profiles}}; \code{\link{list_segments}};
  \code{\link{list_unsampled_reports}};
  \code{\link{list_webproperties}}
}

