% Generated by roxygen2 (4.0.1): do not edit by hand
\name{get_profiles}
\alias{get_profiles}
\title{Lists views (profiles) which the user has access to}
\usage{
get_profiles(account.id = "~all", webproperty.id = "~all",
  start.index = NULL, max.results = NULL, token,
  verbose = getOption("rga.verbose", FALSE))
}
\arguments{
\item{account.id}{character. Account ID for the view (profiles) to retrieve. Can either be a specific account ID or '~all', which refers to all the accounts which the user has access to. Requires specified account.id.}

\item{webproperty.id}{character. Web property ID for the views (profiles) to retrieve. Can either be a specific web property ID or '~all', which refers to all the web properties which the user has access to.}

\item{start.index}{integer. An index of the first entity to retrieve. Use this parameter as a pagination mechanism along with the max-results parameter.}

\item{max.results}{integer. The maximum number of views (profiles) to include in this response.}

\item{token}{\code{\link[httr]{Token2.0}} class object with a valid authorization data.}

\item{verbose}{logical. Should print information verbose?}
}
\value{
A data frame with Google Analytics management data.
\item{accountId}{account ID to which this view (profile) belongs.}
\item{webPropertyId}{web property ID of the form UA-XXXXX-YY to which this view (profile) belongs.}
\item{id}{view (Profile) ID.}
\item{name}{name of this view (profile).}
\item{currency}{the currency type associated with this view (profile).}
\item{timezone}{time zone for which this view (profile) has been configured.}
\item{websiteUrl}{website URL for this view (profile).}
\item{type}{view (Profile) type. Supported types: WEB or APP.}
\item{eCommerceTracking}{indicates whether ecommerce tracking is enabled for this view (profile).}
\item{siteSearchQueryParameters}{the site search query parameters for this view (profile).}
\item{stripSiteSearchQueryParameters}{site search category parameters for this view (profile).}
\item{created}{time this view (profile) was created.}
\item{updated}{time this view (profile) was last modified.}
}
\description{
Lists views (profiles) which the user has access to
}
\references{
\href{https://developers.google.com/analytics/devguides/config/mgmt/v3/mgmtReference/management/profiles}{Google Management API - Views (Profiles)}
}
\seealso{
\code{\link{authorize}}

Other The.Google.Analytics.Management.API: \code{\link{get_accounts}};
  \code{\link{get_goals}}; \code{\link{get_segments}};
  \code{\link{get_webproperties}}
}

