/*
 * Decompiled with CFR 0.152.
 */
package freak.module.operator.initialization;

import edu.cornell.lassp.houle.RngPack.RandomElement;
import freak.core.control.Schedule;
import freak.core.graph.Initialization;
import freak.core.graph.OperatorGraph;
import freak.core.modulesupport.UnsupportedEnvironmentException;
import freak.core.population.Individual;
import freak.core.population.IndividualList;
import freak.core.population.Population;
import freak.module.searchspace.BitString;
import freak.module.searchspace.BitStringGenotype;
import java.util.BitSet;

public class BiasedRandomInitialization
extends Initialization {
    private int size = 1;
    private double probOne = 0.5;

    public BiasedRandomInitialization(OperatorGraph graph) {
        super(graph);
    }

    public void testSchedule(Schedule schedule) throws UnsupportedEnvironmentException {
        super.testSchedule(schedule);
        if (!(schedule.getGenotypeSearchSpace() instanceof BitString)) {
            throw new UnsupportedEnvironmentException("Works only on the search space bit string.");
        }
    }

    public IndividualList[] process(IndividualList[] origin) {
        IndividualList[] result = new IndividualList[]{new Population(this.graph.getSchedule(), this.size)};
        int i = 0;
        while (i < this.size) {
            int dimension = ((BitString)this.graph.getSchedule().getGenotypeSearchSpace()).getDimension();
            BitSet bs = new BitSet(dimension);
            RandomElement re = this.graph.getSchedule().getRandomElement();
            if (re == null) {
                throw new NullPointerException("no random element");
            }
            int j = 0;
            while (j < dimension) {
                double choice = re.uniform(0.0, 1.0);
                if (choice <= this.probOne) {
                    bs.set(j);
                }
                ++j;
            }
            BitStringGenotype bsg = new BitStringGenotype(bs, dimension);
            result[0].addIndividual(new Individual(this.graph.getSchedule(), bsg, new Individual[0]));
            ++i;
        }
        return result;
    }

    public String getName() {
        return "Biased Random Initialization";
    }

    public String getDescription() {
        return "Biased Random Initialization";
    }

    public Integer getPropertySize() {
        return new Integer(this.size);
    }

    public void setPropertySize(Integer no) {
        if (no > 0) {
            this.size = no;
        }
    }

    public String getLongDescriptionForSize() {
        return "The number of individuals to be created.";
    }

    public Double getPropertyProbOne() {
        return new Double(this.probOne);
    }

    public void setPropertyProbOne(Double prop) {
        double p = prop;
        if (p >= 0.0 && p <= 1.0) {
            this.probOne = p;
        }
    }

    public String getShortDescriptionForProbOne() {
        return "Bias";
    }

    public String getLongDescriptionForProbOne() {
        return "The property with which a bit is set to 1";
    }
}

