/*
 * This file is part of RFrEAK. For licensing and copyright information
 * please see the file COPYING in the root directory of this
 * distribution or contact <robin.nunkesser@udo.edu>.
 * 
 * This file is a copy of the original file distributed with
 * FrEAK (http://sourceforge.net/projects/freak427/).
 */

package freak.module.searchspace;

import freak.core.modulesupport.Module;
import freak.core.modulesupport.inspector.Inspector;


/**
 * @author Stefan, Christian
 */
class GraphEdgeSelectionConfigurationPanelUI extends Inspector {
	
	GraphEdgeSelectionConfigurationPanelUI(Module module) {
		super(module);
		initComponents();
	}
	
	/* This method is called from within the constructor to
	 * initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is
	 * always regenerated by the Form Editor.
	 */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        typeLabel = new javax.swing.JLabel();
        typeBox = new javax.swing.JComboBox();
        jSeparator1 = new javax.swing.JSeparator();
        jPanel1 = new javax.swing.JPanel();
        verticesLabel = new javax.swing.JLabel();
        verticesField = new javax.swing.JTextField();
        edgesLabel = new javax.swing.JLabel();
        edgesField = new javax.swing.JTextField();
        probabilityLabel = new javax.swing.JLabel();
        probabilityField = new javax.swing.JTextField();
        trianglesLabel = new javax.swing.JLabel();
        trianglesField = new javax.swing.JTextField();
        weightLabel = new javax.swing.JLabel();
        weightField = new javax.swing.JTextField();
        rngPanel = new javax.swing.JPanel();
        rngLabel = new javax.swing.JLabel();
        rngBox = new javax.swing.JCheckBox();
        seedLabel = new javax.swing.JLabel();
        seedField = new javax.swing.JTextField();
        keepLabel = new javax.swing.JLabel();
        keepBox = new javax.swing.JCheckBox();
        verticesLolliLabel = new javax.swing.JLabel();
        verticesLolliField = new javax.swing.JTextField();
        degreeKLabel = new javax.swing.JLabel();
        degreeKField = new javax.swing.JTextField();

        setLayout(new java.awt.GridBagLayout());

        setBorder(new javax.swing.border.EmptyBorder(new java.awt.Insets(12, 12, 12, 12)));
        typeLabel.setText("Initialization Type:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        add(typeLabel, gridBagConstraints);

        typeBox.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Random with Fixed Edge Number", "Random with Fixed Edge Probability", "Random with Fixed Edge Probability and Binary Value Weights", "Full Graph", "Ingo's Graph", "Star Graph", "Path", "Random Tree", "Lollipop Tree", "k-Tree","Semi-Random-Graph","Semi-Random-Graph with Probability p", "Trap Line"}));
        typeBox.setMinimumSize(new java.awt.Dimension(150, 23));
        typeBox.setPreferredSize(new java.awt.Dimension(150, 23));
        typeBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                typeBoxActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 12, 0, 0);
        add(typeBox, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(6, 0, 0, 0);
        add(jSeparator1, gridBagConstraints);

        jPanel1.setLayout(new java.awt.GridBagLayout());

        verticesLabel.setText("Vertices:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel1.add(verticesLabel, gridBagConstraints);

        verticesField.setColumns(7);
        verticesField.setHorizontalAlignment(javax.swing.JTextField.TRAILING);
        verticesField.setText("30");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 12, 0, 0);
        jPanel1.add(verticesField, gridBagConstraints);

        edgesLabel.setText("Edges:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(6, 0, 0, 0);
        jPanel1.add(edgesLabel, gridBagConstraints);

        edgesField.setColumns(7);
        edgesField.setHorizontalAlignment(javax.swing.JTextField.TRAILING);
        edgesField.setText("50");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(6, 12, 0, 0);
        jPanel1.add(edgesField, gridBagConstraints);

        probabilityLabel.setText("Probability:");
        probabilityLabel.setToolTipText("");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(6, 0, 0, 0);
        jPanel1.add(probabilityLabel, gridBagConstraints);

        probabilityField.setColumns(7);
        probabilityField.setHorizontalAlignment(javax.swing.JTextField.TRAILING);
        probabilityField.setText("0.5");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(6, 12, 0, 0);
        jPanel1.add(probabilityField, gridBagConstraints);

        trianglesLabel.setText("Triangles:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(6, 0, 0, 0);
        jPanel1.add(trianglesLabel, gridBagConstraints);

        trianglesField.setColumns(7);
        trianglesField.setHorizontalAlignment(javax.swing.JTextField.TRAILING);
        trianglesField.setText("15");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(6, 12, 0, 0);
        jPanel1.add(trianglesField, gridBagConstraints);

        weightLabel.setText("Maximal Weight:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(6, 0, 0, 0);
        jPanel1.add(weightLabel, gridBagConstraints);

        weightField.setColumns(7);
        weightField.setHorizontalAlignment(javax.swing.JTextField.TRAILING);
        weightField.setText("1000");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(6, 12, 0, 0);
        jPanel1.add(weightField, gridBagConstraints);

        rngPanel.setLayout(new java.awt.GridBagLayout());

        rngPanel.setBorder(new javax.swing.border.CompoundBorder(new javax.swing.border.TitledBorder("Random Number Generator"), new javax.swing.border.EmptyBorder(new java.awt.Insets(0, 6, 6, 6))));
        rngLabel.setText("Use Independent RNG:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(6, 0, 0, 0);
        rngPanel.add(rngLabel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 0, 0);
        rngPanel.add(rngBox, gridBagConstraints);

        seedLabel.setText("Seed:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(6, 12, 0, 0);
        rngPanel.add(seedLabel, gridBagConstraints);

        seedField.setColumns(7);
        seedField.setHorizontalAlignment(javax.swing.JTextField.TRAILING);
        seedField.setText("12345");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 0, 0);
        rngPanel.add(seedField, gridBagConstraints);

        keepLabel.setText("Keep Graph During Batch:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        rngPanel.add(keepLabel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(0, 6, 0, 0);
        rngPanel.add(keepBox, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(12, 0, 0, 0);
        jPanel1.add(rngPanel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(12, 0, 0, 0);
        add(jPanel1, gridBagConstraints);

        verticesLolliLabel.setText("Vertices (Lolli):");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(6, 0, 0, 0);
        jPanel1.add(verticesLolliLabel, gridBagConstraints);

        verticesLolliField.setColumns(7);
        verticesLolliField.setHorizontalAlignment(javax.swing.JTextField.TRAILING);
        verticesLolliField.setText("10");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(6, 12, 0, 0);
        jPanel1.add(verticesLolliField, gridBagConstraints);

        degreeKLabel.setText("Degree k:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(6, 0, 0, 0);
        jPanel1.add(degreeKLabel, gridBagConstraints);

        degreeKField.setColumns(7);
        degreeKField.setHorizontalAlignment(javax.swing.JTextField.TRAILING);
        degreeKField.setText("2");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(6, 12, 0, 0);
        jPanel1.add(degreeKField, gridBagConstraints);
    }//GEN-END:initComponents

	private void typeBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_typeBoxActionPerformed
		// Add your handling code here:
	}//GEN-LAST:event_typeBoxActionPerformed
	
	
    // Variables declaration - do not modify//GEN-BEGIN:variables
    protected javax.swing.JTextField edgesField;
    protected javax.swing.JLabel edgesLabel;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JSeparator jSeparator1;
    protected javax.swing.JCheckBox keepBox;
    protected javax.swing.JLabel keepLabel;
    protected javax.swing.JTextField probabilityField;
    protected javax.swing.JLabel probabilityLabel;
    protected javax.swing.JCheckBox rngBox;
    protected javax.swing.JLabel rngLabel;
    protected javax.swing.JPanel rngPanel;
    protected javax.swing.JTextField seedField;
    protected javax.swing.JLabel seedLabel;
    protected javax.swing.JTextField trianglesField;
    protected javax.swing.JLabel trianglesLabel;
    protected javax.swing.JComboBox typeBox;
    private javax.swing.JLabel typeLabel;
    protected javax.swing.JTextField verticesField;
    protected javax.swing.JLabel verticesLabel;
    protected javax.swing.JTextField weightField;
    protected javax.swing.JLabel weightLabel;
    protected javax.swing.JTextField verticesLolliField;
    protected javax.swing.JLabel verticesLolliLabel;
    protected javax.swing.JTextField degreeKField;
    protected javax.swing.JLabel degreeKLabel;
    // End of variables declaration//GEN-END:variables
	
}
