/*
 * Decompiled with CFR 0.152.
 */
package freak.module.stoppingcriterion;

import freak.core.control.Schedule;
import freak.core.event.GenerationEvent;
import freak.core.modulesupport.IncompatibleModulePropertyException;
import freak.core.modulesupport.UnsupportedEnvironmentException;
import freak.core.population.Individual;
import freak.core.population.IndividualList;
import freak.core.stoppingcriterion.AbstractGenerationStoppingCriterion;
import freak.module.fitness.generalstring.IsingModelCliques;
import freak.module.searchspace.GeneralString;
import freak.module.searchspace.GeneralStringGenotype;

public class IsingModelCliquesStairsReached
extends AbstractGenerationStoppingCriterion {
    public IsingModelCliquesStairsReached(Schedule schedule) {
        super(schedule);
    }

    public void testSchedule(Schedule schedule) throws UnsupportedEnvironmentException {
        super.testSchedule(schedule);
        if (!(schedule.getRealFitnessFunction() instanceof IsingModelCliques)) {
            throw new UnsupportedEnvironmentException();
        }
        if (((IsingModelCliques)schedule.getRealFitnessFunction()).getPropertyBridgeSelectionStrategy().getIndex() != 2) {
            throw new IncompatibleModulePropertyException(schedule.getRealFitnessFunction(), "Bridge selection strategy", "This observer only works on the bridge distribution named stairs.");
        }
    }

    protected void checkCriterion(GenerationEvent evt) {
        IsingModelCliques ising = (IsingModelCliques)this.getSchedule().getRealFitnessFunction();
        int k = ((GeneralString)this.getSchedule().getPhenotypeSearchSpace()).getNumChars();
        if (ising.getPropertyBridgeSelectionStrategy().getIndex() == 2 && ising.getCliques().length == 2 && k == 2) {
            IndividualList p = this.getSchedule().getPopulationManager().getPopulation();
            Individual ind = p.getIndividualWithRank(1);
            int[] gen = ((GeneralStringGenotype)ind.getGenotype()).getIntArray();
            int n = gen.length;
            int colorOfSecondClique = gen[gen.length - 1];
            int i = n / 2;
            while (i < n) {
                if (gen[i] != colorOfSecondClique) {
                    return;
                }
                ++i;
            }
            boolean change = false;
            int i2 = 0;
            while (i2 < n / 2) {
                if (change) {
                    if (gen[i2] == colorOfSecondClique) {
                        return;
                    }
                } else if (gen[i2] != colorOfSecondClique) {
                    if (i2 >= n / 8) {
                        return;
                    }
                    change = true;
                }
                ++i2;
            }
            this.stopRun();
        }
    }

    public String getName() {
        return "Cliques Stairs Reached";
    }

    public String getDescription() {
        return "Stopps the run if a best individual reached the first half of one stair. The run is only stopped if the bridge distribution STAIRS is used on exactly two cliques with two colors.";
    }
}

