/*
 * Decompiled with CFR 0.152.
 */
package freak.module.fitness.generalstring;

import edu.cornell.lassp.houle.RngPack.RandomElement;
import freak.core.control.Schedule;
import freak.core.event.BatchEvent;
import freak.core.fitness.AbstractStaticSingleObjectiveFitnessFunction;
import freak.core.modulesupport.Configurable;
import freak.core.modulesupport.inspector.Inspector;
import freak.core.population.Genotype;
import freak.core.searchspace.HasDimension;
import freak.module.fitness.generalstring.ChampInspector;
import freak.module.searchspace.GeneralString;
import freak.module.searchspace.GeneralStringGenotype;

public class Champ
extends AbstractStaticSingleObjectiveFitnessFunction
implements Configurable {
    private int[] rule = new int[3];
    private int[][] match;
    private int[] score;
    private boolean randomly = false;

    public Champ(Schedule schedule) {
        super(schedule);
        this.rule[0] = 3;
        this.rule[1] = 0;
        this.rule[2] = 1;
        this.score = new int[10];
        int i = 0;
        while (i < 10) {
            this.score[i] = i;
            ++i;
        }
        this.match = new int[((GeneralString)this.getSchedule().getPhenotypeSearchSpace()).getDimension()][];
        i = 0;
        while (i < ((GeneralString)this.getSchedule().getPhenotypeSearchSpace()).getDimension()) {
            this.match[i] = new int[2];
            this.match[i][0] = i % 10;
            this.match[i][1] = (i + 1) % 10;
            ++i;
        }
    }

    public void initialize() {
        super.initialize();
        int dim = ((HasDimension)((Object)this.getSchedule().getGenotypeSearchSpace())).getDimension();
        if (this.match != null && this.match.length != dim) {
            this.chooseInstance();
        }
    }

    public void batchStarted(BatchEvent evt) {
        if (this.randomly) {
            this.chooseInstance();
        }
    }

    private void chooseInstance() {
        int noOfClubs = ((GeneralString)this.getSchedule().getPhenotypeSearchSpace()).getDimension() / 10;
        if (noOfClubs <= 2) {
            noOfClubs = 3;
        }
        int noOfMatches = noOfClubs / 2;
        RandomElement random = this.getSchedule().getRandomElement();
        int i = 0;
        while (i < noOfMatches) {
            int next;
            this.match[i][0] = random.choose(0, noOfClubs - 1);
            while ((next = random.choose(0, noOfClubs - 1)) == this.match[i][0]) {
            }
            this.match[i][1] = next;
            ++i;
        }
    }

    public double evaluate(Genotype genotype) {
        int[] currentScore = new int[this.score.length];
        int k = 0;
        while (k < this.score.length) {
            currentScore[k] = this.score[k];
            ++k;
        }
        int[] ind = ((GeneralStringGenotype)genotype).getIntArray();
        int k2 = 0;
        while (k2 < this.match.length) {
            if (ind[k2] == 0) {
                int n = this.match[k2][0];
                currentScore[n] = currentScore[n] + this.rule[0];
                int n2 = this.match[k2][1];
                currentScore[n2] = currentScore[n2] + this.rule[2];
            }
            if (ind[k2] == 1) {
                int n = this.match[k2][0];
                currentScore[n] = currentScore[n] + this.rule[1];
                int n3 = this.match[k2][1];
                currentScore[n3] = currentScore[n3] + this.rule[1];
            }
            if (ind[k2] == 2) {
                int n = this.match[k2][0];
                currentScore[n] = currentScore[n] + this.rule[2];
                int n4 = this.match[k2][1];
                currentScore[n4] = currentScore[n4] + this.rule[0];
            }
            ++k2;
        }
        return Math.exp(currentScore[0]);
    }

    public double getOptimalFitnessValue() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public double getLowerBound() throws UnsupportedOperationException {
        return 0.0;
    }

    public double getUpperBound() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public Genotype getPhenotypeOptimum() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public void setPropertyRule(int[] rule) {
        if (rule.length == 3) {
            this.rule = rule;
        }
    }

    public int[] getPropertyRule() {
        return this.rule;
    }

    public void setPropertyMatch(int[][] match) {
        if (match.length == ((GeneralString)this.getSchedule().getPhenotypeSearchSpace()).getDimension()) {
            this.match = match;
        }
    }

    public int[][] getPropertyMatch() {
        return this.match;
    }

    public void setPropertyScore(int[] score) {
        this.score = score;
    }

    public int[] getPropertyScore() {
        return this.score;
    }

    public Boolean getPropertyRandomly() {
        return new Boolean(this.randomly);
    }

    public void setPropertyRandomly(Boolean randomly) {
        this.randomly = randomly;
    }

    public String getDescription() {
        return "Simulates the situation within a soccer-league. Different clubs are competing each other to gain the most points. So there are matches and in each match the winning club and the losing club will get points. Sometimes there is no winner or loser, thus in these situations each of the two clubs will get the same amount of points.\r\nThe MP is described as follows: You have the current situation in the league. It is given in form of a table containing the points of the different clubs. You also have the 'open-matches' which are planned matches, not played yet. And you have one favourite club. The question is: Can this club be at the first place at the end of the tournament, and if it can be, how many points more than the second club can it have.";
    }

    public String getName() {
        return "Champ";
    }

    public Inspector getInspector() {
        return new ChampInspector(this);
    }
}

