/*
 * Decompiled with CFR 0.152.
 */
package freak.rinterface.model;

import freak.core.control.Batch;
import freak.core.control.BatchList;
import freak.core.control.Schedule;
import freak.core.fitness.FitnessFunction;
import freak.core.graph.FreakGraphModel;
import freak.core.graph.Initialization;
import freak.core.mapper.Mapper;
import freak.core.modulesupport.AbstractBasicModule;
import freak.core.modulesupport.AbstractModule;
import freak.core.modulesupport.ModuleInfo;
import freak.core.modulesupport.OperatorGraphCollector;
import freak.core.modulesupport.UnsupportedEnvironmentException;
import freak.core.observer.Observer;
import freak.core.observer.ObserverManager;
import freak.core.observer.ObserverViewMismatchException;
import freak.core.populationmanager.PopulationManager;
import freak.core.searchspace.SearchSpace;
import freak.core.stoppingcriterion.StoppingCriterion;
import freak.core.util.GraphViz;
import freak.gui.graph.OperatorGraphFile;
import freak.gui.scheduleeditor.ScheduleDependencyChecker;
import freak.module.fitness.booleanfunction.GenericPareto;
import freak.module.fitness.pointset.LMSOptimization;
import freak.module.fitness.pointset.LQDOptimization;
import freak.module.fitness.pointset.LQSOptimization;
import freak.module.fitness.pointset.LTAOptimization;
import freak.module.fitness.pointset.LtSOptimization;
import freak.module.fitness.pointset.LtSParetoOptimization;
import freak.module.fitness.pointset.LtSParetoQuantileOptimization;
import freak.module.mapper.pointset.BitStringMapper;
import freak.module.observer.ResultObserver;
import freak.module.operator.initialization.LTSInitialization;
import freak.module.operator.initialization.RandomInitialization;
import freak.module.populationmanager.DefaultPopulationManager;
import freak.module.postprocessor.booleanfunction.Count;
import freak.module.searchspace.BooleanFunction;
import freak.module.searchspace.PointSet;
import freak.module.stoppingcriterion.Duration;
import freak.module.stoppingcriterion.GenerationCount;
import freak.module.stoppingcriterion.PredictingModelFound;
import freak.module.view.RReturn;
import freak.rinterface.model.RDoubleMatrix;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;

public class ScheduleConfigurator {
    static Schedule currentSchedule;
    static boolean editingFinished;

    static {
        editingFinished = false;
    }

    public static Schedule getCurrentSchedule() {
        return currentSchedule;
    }

    public static void setCurrentSchedule(Schedule sched) {
        currentSchedule = sched;
        editingFinished = true;
    }

    private static void updateBatchForSchedule(Schedule schedule, int runs) {
        Batch batch = schedule.createBatchFromCurrentConfigurations();
        batch.setRuns(runs);
        BatchList batchList = schedule.getBatchList();
        batchList.clear();
        batchList.add(batch.copy(), true);
        schedule.setDefaultBatch(batch);
    }

    public static void setDiscriminationR(int runs, int generations) {
        ScheduleConfigurator.setDiscriminationR(runs, generations, 12);
    }

    public static void setDiscriminationR(int runs, int generations, String graphFile) {
        ScheduleConfigurator.setDiscriminationR(runs, generations, 12, false, graphFile);
    }

    public static void setDiscriminationR(int runs, int generations, int sizePruning) {
        ScheduleConfigurator.setDiscriminationR(runs, generations, sizePruning, false);
    }

    public static void setDiscriminationR(int runs, int generations, int sizePruning, boolean stoppingCriterion) {
        ScheduleConfigurator.setDiscriminationR(runs, generations, sizePruning, stoppingCriterion, "GPASGraph.fop");
    }

    public static void setDiscriminationR(int runs, int generations, int sizePruning, boolean stoppingCriterion, String graphFile) {
        ScheduleConfigurator.setDiscrimination("ignored", runs, generations, "ignored", "", sizePruning, stoppingCriterion, graphFile);
    }

    public static void setDiscrimination(String path, int runs, int generations, String testDataPath, String saveTo) {
        ScheduleConfigurator.setDiscrimination(path, runs, generations, testDataPath, saveTo, 12);
    }

    public static void setDiscrimination(String path, int runs, int generations, String testDataPath, String saveTo, int sizePruning) {
        ScheduleConfigurator.setDiscrimination(path, runs, generations, testDataPath, saveTo, sizePruning, false);
    }

    public static void setDiscrimination(String path, int runs, int generations, String testDataPath, String saveTo, int sizePruning, boolean stoppingCriterion) {
        ScheduleConfigurator.setDiscrimination(path, runs, generations, testDataPath, saveTo, sizePruning, false, "GPASGraph.fop");
    }

    public static void setDiscrimination(String path, int runs, int generations, String testDataPath, String saveTo, int sizePruning, boolean stoppingCriterion, String graphFile) {
        AbstractModule m;
        ScheduleConfigurator.createSchedule(path, runs, generations, stoppingCriterion, graphFile);
        try {
            currentSchedule.setFitnessFunction(null);
            m = new GenericPareto(currentSchedule);
            ((GenericPareto)m).setParetoObjective(new int[]{1, 2, 4});
            ((GenericPareto)m).setPropertySubsets(new Integer(1));
            ((GenericPareto)m).setPropertySizePruning(new Integer(sizePruning));
            m.testSchedule(currentSchedule);
            m.initialize();
            m.createEvents();
            currentSchedule.setFitnessFunction((FitnessFunction)((Object)m));
        }
        catch (UnsupportedEnvironmentException e) {
            throw new RuntimeException("Something is wrong with the default Schedule.", e);
        }
        ObserverManager om = currentSchedule.getObserverManager();
        m = new ResultObserver(currentSchedule);
        ((ResultObserver)m).setPropertyTestData(testDataPath);
        if (saveTo.trim().equals("")) {
            RReturn rReturn = new RReturn(currentSchedule);
            try {
                ((Observer)((Object)m)).addView(rReturn);
            }
            catch (ObserverViewMismatchException e) {
                e.printStackTrace();
            }
        } else {
            freak.module.view.FileWriter output = new freak.module.view.FileWriter(currentSchedule);
            output.setPropertyFile(new File(saveTo));
            try {
                ((Observer)((Object)m)).addView(output);
            }
            catch (ObserverViewMismatchException e) {
                e.printStackTrace();
            }
        }
        m.initialize();
        m.createEvents();
        om.addObserver((Observer)((Object)m));
        ScheduleConfigurator.updateBatchForSchedule(currentSchedule, runs);
    }

    public static void setGeccoFitnessFunction(int fitnessfunction) {
        ScheduleConfigurator.setGeccoFitnessFunction(fitnessfunction, 12);
    }

    public static void setGeccoFitnessFunction(int fitnessfunction, int sizePruning) {
        try {
            currentSchedule.setFitnessFunction(null);
            GenericPareto m = new GenericPareto(currentSchedule);
            switch (fitnessfunction) {
                case 1: {
                    int[] nArray = new int[3];
                    nArray[0] = 12;
                    nArray[1] = 12;
                    m.setParetoObjective(nArray);
                    break;
                }
                case 2: {
                    int[] nArray = new int[3];
                    nArray[0] = 13;
                    nArray[1] = 13;
                    m.setParetoObjective(nArray);
                    break;
                }
                case 3: {
                    int[] nArray = new int[3];
                    nArray[0] = 5;
                    nArray[1] = 4;
                    m.setParetoObjective(nArray);
                    break;
                }
                case 4: {
                    m.setParetoObjective(new int[]{1, 2, 4});
                }
            }
            m.setPropertySubsets(new Integer(1));
            m.setPropertySizePruning(new Integer(sizePruning));
            m.testSchedule(currentSchedule);
            m.initialize();
            m.createEvents();
            currentSchedule.setFitnessFunction(m);
        }
        catch (UnsupportedEnvironmentException e) {
            throw new RuntimeException("Something is wrong with the default Schedule.", e);
        }
    }

    public static void setInteractionR(int runs, int generations, String graphFile, int occurences, double ratio) {
        ScheduleConfigurator.setInteraction("ignored", runs, generations, graphFile, occurences, ratio, "");
    }

    public static void setInteraction(String path, int runs, int generations, String graphFile, int occurences, double ratio, String saveTo) {
        AbstractModule m;
        ScheduleConfigurator.createSchedule(path, runs, generations);
        try {
            currentSchedule.setFitnessFunction(null);
            m = new GenericPareto(currentSchedule);
            ((GenericPareto)m).setParetoObjective(new int[]{3, 2, 4});
            ((GenericPareto)m).setPropertySubsets(new Integer(1));
            ((GenericPareto)m).setPropertySizePruning(new Integer(12));
            m.testSchedule(currentSchedule);
            m.initialize();
            m.createEvents();
            currentSchedule.setFitnessFunction((FitnessFunction)((Object)m));
        }
        catch (UnsupportedEnvironmentException e) {
            throw new RuntimeException("Something is wrong with the default Schedule.", e);
        }
        ObserverManager om = currentSchedule.getObserverManager();
        m = new ResultObserver(currentSchedule);
        ((ResultObserver)m).setPropertyTestData("");
        if (saveTo.trim().equals("")) {
            RReturn rReturn = new RReturn(currentSchedule);
            try {
                ((Observer)((Object)m)).addView(rReturn);
            }
            catch (ObserverViewMismatchException e) {
                e.printStackTrace();
            }
        } else {
            freak.module.view.FileWriter output = new freak.module.view.FileWriter(currentSchedule);
            output.setPropertyFile(new File(saveTo));
            try {
                ((Observer)((Object)m)).addView(output);
            }
            catch (ObserverViewMismatchException e) {
                e.printStackTrace();
            }
        }
        ((ResultObserver)m).setPostprocessor(-1);
        ((ResultObserver)m).setSelectPostprocessorFromGui(false);
        Count postprocessor = new Count(currentSchedule);
        Count.fileName = graphFile;
        Count.minCount = occurences;
        Count.minPercent = ratio;
        ((ResultObserver)m).setSelectedProcessor(postprocessor);
        m.initialize();
        m.createEvents();
        om.addObserver((Observer)((Object)m));
        ScheduleConfigurator.updateBatchForSchedule(currentSchedule, runs);
    }

    public static void setGenerationCount(int gencount) {
        try {
            GenerationCount generationCount = new GenerationCount(currentSchedule);
            generationCount.setPropertyCount(new Integer(gencount));
            generationCount.testSchedule(currentSchedule);
            generationCount.initialize();
            generationCount.createEvents();
            StoppingCriterion[] stoppingCriteria = new StoppingCriterion[]{generationCount};
            currentSchedule.setStoppingCriteria(stoppingCriteria);
        }
        catch (UnsupportedEnvironmentException e) {
            throw new RuntimeException("Something is wrong with the default Schedule.", e);
        }
        System.out.println("GenerationCount has been set from R");
    }

    public static void setOperatorGraph(String ogLocation) {
        File f = new File(ogLocation);
        try {
            OperatorGraphFile ogFile = OperatorGraphFile.read(new FileInputStream(f));
            FreakGraphModel model = ogFile.generateGraph(currentSchedule);
            currentSchedule.setGraphModel(model);
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        System.out.println("OperatorGraph has been set from R");
    }

    public static void printOperatorGraph() {
        GraphViz gv = new GraphViz();
        FreakGraphModel model = currentSchedule.getGraphModel();
        String dotSource = model.getOperatorGraph().toDotGraph();
        File graphDot = new File("operatorgraph.dot");
        try {
            FileWriter fout = new FileWriter(graphDot);
            fout.write(dotSource);
            fout.close();
        }
        catch (Exception e) {
            System.err.println("Error: I/O error while writing the dot source");
        }
        File graphGif = new File("operatorgraph.gif");
        GraphViz.DOT = "C:\\Program Files\\graphviz\\Graphviz\\bin\\dot";
        try {
            gv.writeGraphToFile(gv.getGraph(dotSource), graphGif);
        }
        catch (Exception e1) {
            GraphViz.DOT = "/usr/local/graphviz-2.12/bin/dot";
            try {
                gv.writeGraphToFile(gv.getGraph(dotSource), graphGif);
            }
            catch (Exception e2) {
                System.out.println("DOT not found");
            }
        }
    }

    public static Schedule getLTSSchedule(RDoubleMatrix data, int h, boolean adjust, int runs, int generationCountStop) {
        return ScheduleConfigurator.getLTSSchedule(data, h, adjust, runs, generationCountStop, 0, 0);
    }

    public static Schedule getLTSSchedule(RDoubleMatrix data, int h, boolean adjust, int runs, int generationCountStop, int duration, String fitnessFunction) {
        int function = 0;
        if (fitnessFunction.equals("lts")) {
            function = 0;
        }
        if (fitnessFunction.equals("lms")) {
            function = 1;
        }
        if (fitnessFunction.equals("lta")) {
            function = 6;
        }
        if (fitnessFunction.equals("lqs")) {
            function = 7;
        }
        if (fitnessFunction.equals("lqd")) {
            function = 8;
        }
        return ScheduleConfigurator.getLTSSchedule(data, h, adjust, runs, generationCountStop, duration, function);
    }

    public static Schedule getLTSSchedule(RDoubleMatrix data, int h, boolean adjust, int runs, int generationCountStop, int duration, int fitnessFunction) {
        Schedule schedule = new Schedule();
        ScheduleDependencyChecker scheduleDependencyChecker = new ScheduleDependencyChecker(null);
        scheduleDependencyChecker.setSchedule(schedule);
        try {
            AbstractBasicModule m = new PointSet(schedule);
            int noOfPoints = data.getDim()[0];
            int dimension = data.getDim()[1];
            PointSet.Point[] points = new PointSet.Point[noOfPoints];
            int i = 0;
            while (i < noOfPoints) {
                points[i] = new PointSet.Point(dimension);
                int j = 0;
                while (j < dimension) {
                    points[i].setK(j, data.getValues()[i + j * noOfPoints]);
                    ++j;
                }
                ++i;
            }
            ((PointSet)m).setPoints(points);
            m.testSchedule(schedule);
            m.initialize();
            m.createEvents();
            schedule.setPhenotypeSearchSpace((SearchSpace)((Object)m));
            switch (fitnessFunction) {
                case 0: {
                    m = new LtSOptimization(schedule);
                    ((LtSOptimization)m).setPropertyH(new Integer(h));
                    ((LtSOptimization)m).setPropertyAdjust(adjust);
                    break;
                }
                case 1: {
                    m = new LMSOptimization(schedule);
                    ((LMSOptimization)m).setPropertyH(new Integer(h));
                    ((LMSOptimization)m).setPropertyAdjust(adjust);
                    break;
                }
                case 2: {
                    m = new LtSParetoQuantileOptimization(schedule);
                    ((LtSParetoQuantileOptimization)m).setPropertyH(new Integer(h));
                    ((LtSParetoQuantileOptimization)m).setPropertyAdjust(adjust);
                    break;
                }
                case 3: {
                    m = new LtSParetoOptimization(schedule);
                    ((LtSParetoOptimization)m).setPropertyH(new Integer(h));
                    ((LtSParetoOptimization)m).setPropertyAdjust(adjust);
                    break;
                }
                case 4: {
                    m = new LtSParetoQuantileOptimization(schedule);
                    ((LtSParetoQuantileOptimization)m).setPropertyH(new Integer(h));
                    ((LtSParetoQuantileOptimization)m).setPropertyAdjust(adjust);
                    break;
                }
                case 5: {
                    m = new LtSParetoOptimization(schedule);
                    ((LtSParetoOptimization)m).setPropertyH(new Integer(h));
                    ((LtSParetoOptimization)m).setPropertyAdjust(adjust);
                    break;
                }
                case 6: {
                    m = new LTAOptimization(schedule);
                    ((LTAOptimization)m).setPropertyH(new Integer(h));
                    ((LTAOptimization)m).setPropertyAdjust(adjust);
                    break;
                }
                case 7: {
                    m = new LQSOptimization(schedule);
                    ((LQSOptimization)m).setPropertyH(new Integer(h));
                    break;
                }
                case 8: {
                    m = new LQDOptimization(schedule);
                    ((LQDOptimization)m).setPropertyH(new Integer(h));
                }
            }
            m.testSchedule(schedule);
            m.initialize();
            m.createEvents();
            schedule.setFitnessFunction((FitnessFunction)((Object)m));
            m = new BitStringMapper(schedule);
            m.testSchedule(schedule);
            m.initialize();
            m.createEvents();
            schedule.setMapper((Mapper)((Object)m));
            if (generationCountStop > 0) {
                GenerationCount generationCount = new GenerationCount(schedule);
                generationCount.setPropertyCount(new Integer(generationCountStop));
                generationCount.testSchedule(schedule);
                generationCount.initialize();
                generationCount.createEvents();
                StoppingCriterion[] stoppingCriteria = new StoppingCriterion[]{generationCount};
                schedule.setStoppingCriteria(stoppingCriteria);
            }
            if (duration > 0) {
                Duration durationObject = new Duration(schedule);
                durationObject.setPropertyDuration(new Integer(duration));
                durationObject.testSchedule(schedule);
                durationObject.initialize();
                durationObject.createEvents();
                StoppingCriterion[] stoppingCriteria = new StoppingCriterion[]{durationObject};
                schedule.setStoppingCriteria(stoppingCriteria);
            }
            m = new DefaultPopulationManager(schedule);
            m.testSchedule(schedule);
            m.initialize();
            m.createEvents();
            schedule.setPopulationManager((PopulationManager)((Object)m));
            OperatorGraphCollector collector = new OperatorGraphCollector(schedule);
            ModuleInfo[] graphs = null;
            if (fitnessFunction <= 1 || fitnessFunction > 5) {
                graphs = collector.getPredefinedGraphs("LTSGraph.fop");
            } else if (fitnessFunction <= 3) {
                graphs = collector.getPredefinedGraphs("LTSCrossover.fop");
            } else if (fitnessFunction <= 5) {
                graphs = collector.getPredefinedGraphs("LTSCrossMove.fop");
            }
            if (graphs != null) {
                try {
                    OperatorGraphFile ogFile = OperatorGraphFile.read(new FileInputStream(new File(graphs[0].getClassName())));
                    FreakGraphModel model = ogFile.generateGraph(schedule);
                    model.getOperatorGraph().setName(graphs[0].getName());
                    schedule.setGraphModel(model);
                }
                catch (Exception exc) {
                    System.out.println("Error loading graph " + graphs[0].getClassName());
                    exc.printStackTrace();
                }
            }
            m = new LTSInitialization(schedule.getOperatorGraph());
            ((LTSInitialization)m).setPropertyNoOfBitsSetted(dimension);
            m.testSchedule(schedule);
            m.initialize();
            m.createEvents();
            ((Initialization)m).hideNameProperty();
            schedule.setInitialization((Initialization)m);
            ObserverManager om = schedule.getObserverManager();
            m = new ResultObserver(schedule);
            RReturn rReturn = new RReturn(schedule);
            try {
                ((Observer)((Object)m)).addView(rReturn);
            }
            catch (ObserverViewMismatchException e) {
                e.printStackTrace();
            }
            m.initialize();
            m.createEvents();
            om.addObserver((Observer)((Object)m));
        }
        catch (UnsupportedEnvironmentException e) {
            throw new RuntimeException("Something is wrong with the default Schedule.", e);
        }
        ScheduleConfigurator.updateBatchForSchedule(schedule, runs);
        schedule.modulesEdited();
        return schedule;
    }

    public static Schedule createSchedule(String path, int runs, int generationCountStop) {
        return ScheduleConfigurator.createSchedule(path, runs, generationCountStop, false);
    }

    public static Schedule createSchedule(String path, int runs, int generationCountStop, boolean stoppingCriterion) {
        return ScheduleConfigurator.createSchedule(path, runs, generationCountStop, false, "GPASGraph.fop");
    }

    public static Schedule createSchedule(String path, int runs, int generationCountStop, boolean stoppingCriterion, String graphFile) {
        Schedule schedule = new Schedule();
        ScheduleDependencyChecker scheduleDependencyChecker = new ScheduleDependencyChecker(null);
        scheduleDependencyChecker.setSchedule(schedule);
        try {
            AbstractBasicModule m = new BooleanFunction(schedule);
            ((BooleanFunction)m).setPropertyInputPath(path);
            m.testSchedule(schedule);
            m.initialize();
            m.createEvents();
            schedule.setPhenotypeSearchSpace((SearchSpace)((Object)m));
            m = new GenericPareto(schedule);
            m.testSchedule(schedule);
            m.initialize();
            m.createEvents();
            schedule.setFitnessFunction((FitnessFunction)((Object)m));
            if (generationCountStop > 0 || stoppingCriterion) {
                GenerationCount generationCount = new GenerationCount(schedule);
                generationCount.setPropertyCount(new Integer(generationCountStop));
                generationCount.testSchedule(schedule);
                generationCount.initialize();
                generationCount.createEvents();
                PredictingModelFound predictionFound = new PredictingModelFound(schedule);
                predictionFound.testSchedule(schedule);
                predictionFound.initialize();
                predictionFound.createEvents();
                StoppingCriterion[] stoppingCriteria = null;
                stoppingCriteria = generationCountStop > 0 && stoppingCriterion ? new StoppingCriterion[]{generationCount, predictionFound} : (generationCountStop > 0 ? new StoppingCriterion[]{generationCount} : new StoppingCriterion[]{predictionFound});
                schedule.setStoppingCriteria(stoppingCriteria);
            }
            m = new DefaultPopulationManager(schedule);
            m.testSchedule(schedule);
            m.initialize();
            m.createEvents();
            schedule.setPopulationManager((PopulationManager)((Object)m));
            OperatorGraphCollector collector = new OperatorGraphCollector(schedule);
            ModuleInfo[] graphs = collector.getPredefinedGraphs(graphFile);
            if (graphs != null) {
                try {
                    OperatorGraphFile ogFile = OperatorGraphFile.read(new FileInputStream(new File(graphs[0].getClassName())));
                    FreakGraphModel model = ogFile.generateGraph(schedule);
                    model.getOperatorGraph().setName(graphs[0].getName());
                    schedule.setGraphModel(model);
                }
                catch (Exception exc) {
                    System.out.println("Error loading graph " + graphs[0].getClassName());
                    exc.printStackTrace();
                }
            }
            m = new RandomInitialization(schedule.getOperatorGraph());
            m.testSchedule(schedule);
            m.initialize();
            m.createEvents();
            ((Initialization)m).hideNameProperty();
            schedule.setInitialization((Initialization)m);
        }
        catch (UnsupportedEnvironmentException e) {
            throw new RuntimeException("Something is wrong with the default Schedule.", e);
        }
        ScheduleConfigurator.updateBatchForSchedule(schedule, runs);
        schedule.modulesEdited();
        currentSchedule = schedule;
        return schedule;
    }

    public static Schedule createDefaultSchedule() {
        currentSchedule = ScheduleConfigurator.createSchedule("./data/snap.csv", 1, 0);
        ObserverManager om = currentSchedule.getObserverManager();
        ResultObserver m = new ResultObserver(currentSchedule);
        RReturn rReturn = new RReturn(currentSchedule);
        try {
            ((Observer)m).addView(rReturn);
        }
        catch (ObserverViewMismatchException e) {
            e.printStackTrace();
        }
        m.initialize();
        m.createEvents();
        om.addObserver(m);
        ScheduleConfigurator.updateBatchForSchedule(currentSchedule, 1);
        return currentSchedule;
    }

    public static boolean isEditingFinished() {
        return editingFinished;
    }

    public static void setEditingFinished(boolean editingFinished) {
        ScheduleConfigurator.editingFinished = editingFinished;
    }
}

