/*
 * Decompiled with CFR 0.152.
 */
package freak.module.operator.initialization.bitstring;

import edu.cornell.lassp.houle.RngPack.RandomElement;
import freak.core.control.Schedule;
import freak.core.graph.GraphException;
import freak.core.graph.Initialization;
import freak.core.graph.OperatorGraph;
import freak.core.modulesupport.Configurable;
import freak.core.modulesupport.UnsupportedEnvironmentException;
import freak.core.population.Individual;
import freak.core.population.IndividualList;
import freak.core.population.Population;
import freak.module.searchspace.BitString;
import freak.module.searchspace.BitStringGenotype;

public class KBitInitialization
extends Initialization
implements Configurable {
    protected int kBits = 1;
    protected int size = 1;

    public KBitInitialization(OperatorGraph graph) {
        super(graph);
    }

    public void testSchedule(Schedule schedule) throws UnsupportedEnvironmentException {
        super.testSchedule(schedule);
        if (!(this.graph.getSchedule().getGenotypeSearchSpace() instanceof BitString)) {
            throw new UnsupportedEnvironmentException("Works only on the SearchSpace BitString.");
        }
    }

    public IndividualList[] process(IndividualList[] input) throws GraphException {
        IndividualList[] result = new IndividualList[]{new Population(this.graph.getSchedule(), this.size)};
        int dimension = ((BitString)this.graph.getSchedule().getGenotypeSearchSpace()).getDimension();
        RandomElement re = this.graph.getSchedule().getRandomElement();
        int i = 0;
        while (i < this.size) {
            boolean[] bs = new boolean[dimension];
            int k = 0;
            while (k < this.kBits) {
                int p = re.choose(0, dimension - 1);
                while (bs[p]) {
                    p = re.choose(0, dimension - 1);
                }
                bs[p] = true;
                ++k;
            }
            BitStringGenotype geno = new BitStringGenotype(bs);
            result[0].addIndividual(new Individual(this.graph.getSchedule(), geno, null));
            ++i;
        }
        return result;
    }

    public Integer getPropertyNoOfBitsSetted() {
        return new Integer(this.kBits);
    }

    public void setPropertyNoOfBitsSetted(Integer no) {
        if (no > 0) {
            this.kBits = no;
        }
    }

    public String getShortDescriptionForNoOfBitsSetted() {
        return "No of set Bits";
    }

    public String getLongDescriptionForNoOfBitsSetted() {
        return "The number of randomised set Bits in the Bitstring";
    }

    public Integer getPropertySize() {
        return new Integer(this.size);
    }

    public void setPropertySize(Integer no) {
        if (no > 0) {
            this.size = no;
        }
    }

    public String getLongDescriptionForSize() {
        return "The number of individuals to be created.";
    }

    public String getName() {
        return "KBitInitialization";
    }

    public String getDescription() {
        return "Creates BitString Invdividauls with k Bits setted";
    }
}

