/*
 * Decompiled with CFR 0.152.
 */
package freak.module.operator.split;

import freak.core.graph.CompatibleWithDifferentSearchSpaces;
import freak.core.graph.GraphException;
import freak.core.graph.OperatorGraph;
import freak.core.graph.Split;
import freak.core.modulesupport.Configurable;
import freak.core.population.IndividualList;
import freak.core.population.Population;

public class ChoiceGeneration
extends Split
implements Configurable,
CompatibleWithDifferentSearchSpaces {
    private double probability = 0.5;

    public ChoiceGeneration(OperatorGraph graph) {
        super(graph);
        this.addOutPort();
        this.addOutPort();
    }

    public IndividualList[] process(IndividualList[] input) throws GraphException {
        Population empty = new Population(this.getOperatorGraph().getSchedule());
        int generation = this.getOperatorGraph().getSchedule().getCurrentGeneration();
        if (generation == 2) {
            return new IndividualList[]{input[0], empty};
        }
        return new IndividualList[]{empty, input[0]};
    }

    public Double getPropertyProbability() {
        return new Double(this.probability);
    }

    public void setPropertyProbability(Double probability) {
        if (probability > 1.0 || probability < 0.0) {
            return;
        }
        this.probability = probability;
    }

    public String getLongDescriptionForProbability() {
        return "Will be ignored.";
    }

    public String getDescription() {
        return "Choice routes all individuals either to the first or to the second outport, depending on the generation.If generation=1 then the individuals will be routed to the first port.";
    }

    public String getName() {
        return "ChoiceGeneration";
    }
}

