/*
 * Decompiled with CFR 0.152.
 */
package freak.module.operator.selection;

import freak.core.graph.CompatibleWithDifferentSearchSpaces;
import freak.core.graph.GraphException;
import freak.core.graph.OperatorGraph;
import freak.core.graph.Selection;
import freak.core.population.Individual;
import freak.core.population.IndividualList;
import freak.core.population.Population;
import java.util.Iterator;
import java.util.Vector;

public class FairSelection
extends Selection
implements CompatibleWithDifferentSearchSpaces {
    public FairSelection(OperatorGraph graph) {
        super(graph);
        super.addInPort();
        super.addOutPort();
    }

    public IndividualList[] process(IndividualList[] input) throws GraphException {
        Object o;
        IndividualList[] result = new IndividualList[1];
        if (input[0].size() == 0) {
            result[0] = input[0];
            return result;
        }
        int min = Integer.MAX_VALUE;
        Vector<Individual> selection = new Vector<Individual>();
        Iterator it = input[0].iterator();
        while (it.hasNext()) {
            Individual ind = (Individual)it.next();
            int numSelected = 0;
            o = ind.getTag("NumSelected");
            if (o != null) {
                numSelected = (Integer)o;
            }
            if (numSelected < min) {
                selection = new Vector();
                selection.add(ind);
                min = numSelected;
                continue;
            }
            if (numSelected != min) continue;
            selection.add(ind);
        }
        result[0] = new Population(this.getOperatorGraph().getSchedule());
        int n = this.getOperatorGraph().getSchedule().getRandomElement().choose(0, selection.size() - 1);
        Individual selected = (Individual)selection.elementAt(n);
        result[0].addIndividual(selected);
        o = selected.getTag("NumSelected");
        if (o != null) {
            int num = (Integer)o + 1;
            selected.addTag("NumSelected", new Integer(num), 1);
        } else {
            selected.addTag("NumSelected", new Integer(1), 1);
        }
        return result;
    }

    public String getName() {
        return "Fair Selection";
    }

    public String getDescription() {
        return "Fair Selection";
    }
}

