/*
 * Decompiled with CFR 0.152.
 */
package freak.module.observer;

import freak.core.control.Schedule;
import freak.core.event.EventListener;
import freak.core.event.RunEvent;
import freak.core.event.RunEventListener;
import freak.core.fitness.MultiObjectiveFitnessFunction;
import freak.core.fitness.SingleObjectiveFitnessFunction;
import freak.core.observer.AbstractObserver;
import freak.core.population.Individual;
import freak.core.population.IndividualList;
import java.util.Iterator;

public class SummaryObserver
extends AbstractObserver
implements RunEventListener {
    public SummaryObserver(Schedule schedule) {
        super(schedule);
        this.setMeasure(2);
    }

    public Class getOutputDataType() {
        return Summary.class;
    }

    public String getName() {
        return "Summary";
    }

    public String getDescription() {
        return "Draws a summary of all runs.";
    }

    public void runFinalize(RunEvent evt) {
        IndividualList lastPopulation;
        Summary summary;
        block2: {
            summary = new Summary();
            lastPopulation = this.getSchedule().getPopulationManager().getPopulation();
            try {
                summary.setBestIndividuals(lastPopulation.getAllIndividualsWithRank(1));
            }
            catch (Exception e) {
                if (!(this.schedule.getFitnessFunction() instanceof MultiObjectiveFitnessFunction)) break block2;
                summary.setBestIndividuals(lastPopulation);
            }
        }
        summary.setLastPopulationSize(lastPopulation.size());
        summary.setNumberOfGenerations(this.getSchedule().getCurrentGeneration());
        summary.setRunNumber(evt.getRunIndex().run);
        this.updateViews(summary);
    }

    public void createEvents() {
        this.schedule.getEventController().addEvent((EventListener)this, RunEvent.class, this.schedule);
    }

    class Summary {
        private int runNumber;
        private int numberOfGenerations;
        private int lastPopulationSize;
        private IndividualList bestIndividuals;

        Summary() {
        }

        public IndividualList getBestIndividuals() {
            return this.bestIndividuals;
        }

        public int getLastPopulationSize() {
            return this.lastPopulationSize;
        }

        public int getNumberOfGenerations() {
            return this.numberOfGenerations;
        }

        public void setBestIndividuals(IndividualList individuals) {
            this.bestIndividuals = individuals;
        }

        public void setLastPopulationSize(int i) {
            this.lastPopulationSize = i;
        }

        public void setNumberOfGenerations(int i) {
            this.numberOfGenerations = i;
        }

        public String toString() {
            StringBuffer s = new StringBuffer("Summary of run " + this.getRunNumber() + "\n\n");
            s.append("Optimization time in generations: " + this.getNumberOfGenerations() + "\n");
            s.append("Size of final population: " + this.getLastPopulationSize() + "\n");
            if (SummaryObserver.this.getSchedule().getRealFitnessFunction() instanceof SingleObjectiveFitnessFunction || SummaryObserver.this.getSchedule().getRealFitnessFunction() instanceof MultiObjectiveFitnessFunction) {
                if (SummaryObserver.this.getSchedule().getRealFitnessFunction() instanceof SingleObjectiveFitnessFunction) {
                    double fitness = ((SingleObjectiveFitnessFunction)SummaryObserver.this.getSchedule().getFitnessFunction()).evaluate(this.getBestIndividuals().getRandomIndividual(), SummaryObserver.this.getSchedule().getPopulationManager().getPopulation());
                    s.append("Best individuals of final population with fitness: " + fitness + "\n");
                } else {
                    s.append("Individuals of final population: \n");
                }
                Iterator iter = this.getBestIndividuals().iterator();
                while (iter.hasNext()) {
                    Individual individual = (Individual)iter.next();
                    s.append(individual.toString());
                    s.append("\n");
                }
            }
            return s.toString();
        }

        public int getRunNumber() {
            return this.runNumber;
        }

        public void setRunNumber(int i) {
            this.runNumber = i;
        }
    }
}

