/*
 * Decompiled with CFR 0.152.
 */
package freak.gui.scheduleeditor;

import freak.core.modulesupport.Configurable;
import freak.core.modulesupport.Configuration;
import freak.core.modulesupport.Module;
import freak.core.modulesupport.UnsupportedEnvironmentException;
import freak.core.observer.Observer;
import freak.core.observer.ObserverManager;
import freak.core.observer.ObserverViewMismatchException;
import freak.core.view.View;
import freak.gui.JButtonFactory;
import freak.gui.ModuleList;
import freak.gui.scheduleeditor.ObserverTreeCellRenderer;
import freak.gui.scheduleeditor.ObserverTreeElement;
import freak.gui.scheduleeditor.ScheduleEditor;
import freak.gui.scheduleeditor.ScheduleEditorPanel;
import freak.gui.scheduleeditor.Util;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.border.BevelBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;

public class PanelObservers
extends ScheduleEditorPanel {
    private ObserverManager observerManager;
    private Module[] observers;
    private Module[] views;
    private DefaultMutableTreeNode rootNode;
    private DefaultTreeModel treeModel;
    private JButton buAddObserver;
    private JButton buAddView;
    private JButton buObsItemConfig;
    private JButton buObsItemDelete;
    private JLabel jLabel1;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JPanel jPanel12;
    private JPanel jPanel7;
    private JPanel jPanel9;
    private JScrollPane jScrollPane15;
    private JScrollPane jScrollPane16;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JList listObservers;
    private JList listViews;
    private JTextArea taDescrObserver;
    private JTextArea taDescrView;
    private JTextField tfOptionsObserver;
    private JTree treeObsItems;

    public PanelObservers(ScheduleEditor scheduleEditor) {
        super(scheduleEditor);
        this.initComponents();
        this.observerManager = this.schedule.getObserverManager();
        this.initTree();
    }

    public static String getDescription() {
        return "Create Observers and Views";
    }

    public String getHelpURL() {
        return "node4.html#SECTION00451000000000000000";
    }

    private void initTree() {
        this.rootNode = new DefaultMutableTreeNode();
        this.treeModel = new DefaultTreeModel(this.rootNode);
        this.treeObsItems.setModel(this.treeModel);
        ObserverTreeCellRenderer renderer = new ObserverTreeCellRenderer();
        this.treeObsItems.setModel(this.treeModel);
        this.treeObsItems.setCellRenderer(renderer);
        this.treeObsItems.setRootVisible(false);
        this.treeObsItems.setShowsRootHandles(true);
        this.treeObsItems.getSelectionModel().setSelectionMode(1);
        this.treeObsItems.setExpandsSelectedPaths(true);
        ToolTipManager.sharedInstance().registerComponent(this.treeObsItems);
    }

    public boolean advanceVeto() {
        return !this.scheduleDependencyChecker.isObserverSetupOk();
    }

    public void enter() {
        this.observers = this.moduleCollector.getObservers();
        ((ModuleList)this.listObservers).setModules(this.observers, null);
        this.buAddObserver.setEnabled(this.observers.length > 0);
        this.parseObservers();
    }

    private void parseObservers() {
        List obs = this.observerManager.getActiveObservers();
        for (Observer o : obs) {
            ObserverTreeElement obsElement = new ObserverTreeElement(o);
            DefaultMutableTreeNode obsNode = new DefaultMutableTreeNode(obsElement);
            Iterator j = o.getViews().iterator();
            if (j.hasNext()) {
                while (j.hasNext()) {
                    View v = (View)j.next();
                    ObserverTreeElement vElement = new ObserverTreeElement(v);
                    DefaultMutableTreeNode viewNode = new DefaultMutableTreeNode(vElement);
                    obsNode.add(viewNode);
                }
            } else {
                DefaultMutableTreeNode viewNode = new DefaultMutableTreeNode(ObserverTreeElement.getNoViewTreeElement());
                obsNode.add(viewNode);
            }
            this.treeModel.insertNodeInto(obsNode, this.rootNode, this.rootNode.getChildCount());
            this.treeObsItems.expandPath(new TreePath(obsNode.getPath()));
        }
    }

    private void createListOfViews(Observer observer) {
        this.views = this.moduleCollector.getViews();
        ArrayList<Module> compatibleViews = new ArrayList<Module>();
        int i = 0;
        while (i < this.views.length) {
            try {
                observer.addView((View)this.views[i]);
                compatibleViews.add(this.views[i]);
                observer.removeView((View)this.views[i]);
            }
            catch (ObserverViewMismatchException observerViewMismatchException) {
                // empty catch block
            }
            ++i;
        }
        this.views = new Module[compatibleViews.size()];
        i = 0;
        while (i < compatibleViews.size()) {
            this.views[i] = (Module)compatibleViews.get(i);
            ++i;
        }
        ((ModuleList)this.listViews).setModules(this.views, null);
        this.buAddView.setEnabled(!compatibleViews.isEmpty());
        this.listViews.setEnabled(!compatibleViews.isEmpty());
        this.listViews.removeSelectionInterval(this.listViews.getMinSelectionIndex(), this.listViews.getMaxSelectionIndex());
    }

    private void addObserver(Observer o) {
        this.observerManager.addObserver(o);
        DefaultMutableTreeNode obsNode = new DefaultMutableTreeNode(new ObserverTreeElement(o));
        obsNode.add(new DefaultMutableTreeNode(ObserverTreeElement.getNoViewTreeElement()));
        this.treeModel.insertNodeInto(obsNode, this.rootNode, this.rootNode.getChildCount());
        TreePath path = new TreePath(obsNode.getPath());
        this.treeObsItems.setSelectionPath(path);
    }

    private void addView(View v, DefaultMutableTreeNode obsNode) {
        DefaultMutableTreeNode viewNode = new DefaultMutableTreeNode(new ObserverTreeElement(v));
        ObserverTreeElement ote = (ObserverTreeElement)obsNode.getUserObject();
        if (ote != null) {
            Module mod = ote.getModule();
            if (mod instanceof Observer) {
                Observer obs = (Observer)mod;
                try {
                    obs.addView(v);
                }
                catch (ObserverViewMismatchException e) {
                    e.printStackTrace();
                    System.out.println("view doesn't match observer!");
                }
            } else {
                System.out.println("parent is not an observer");
            }
        } else {
            System.out.println("parent is null?!?");
        }
        if (obsNode.getChildAt(0).toString().equals(ObserverTreeElement.getNoViewTreeElement().toString())) {
            this.treeModel.removeNodeFromParent((MutableTreeNode)obsNode.getChildAt(0));
        }
        this.treeModel.insertNodeInto(viewNode, obsNode, obsNode.getChildCount());
        TreePath path = new TreePath(viewNode.getPath());
        this.treeObsItems.setSelectionPath(path);
    }

    private void deleteNode(DefaultMutableTreeNode node) {
        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)node.getParent();
        this.treeObsItems.setSelectionRow(this.treeObsItems.getSelectionRows()[0] - 1);
        ObserverTreeElement nodeObj = (ObserverTreeElement)node.getUserObject();
        if (nodeObj.getModule() instanceof View) {
            View v = (View)nodeObj.getModule();
            Observer o = (Observer)((ObserverTreeElement)parentNode.getUserObject()).getModule();
            o.removeView(v);
            this.schedule.getEventController().removeModule(v);
        } else if (nodeObj.getModule() instanceof Observer) {
            Observer o = (Observer)nodeObj.getModule();
            this.observerManager.removeObserver(o);
            for (View v : o.getViews()) {
                this.schedule.getEventController().removeModule(v);
            }
            this.schedule.getEventController().removeModule(o);
        }
        this.treeModel.removeNodeFromParent(node);
        if (parentNode != this.rootNode && parentNode.getChildCount() == 0) {
            this.treeModel.insertNodeInto(new DefaultMutableTreeNode(ObserverTreeElement.getNoViewTreeElement()), parentNode, 0);
        }
    }

    private void initComponents() {
        this.jPanel7 = new JPanel();
        this.jScrollPane4 = new JScrollPane();
        this.treeObsItems = new JTree();
        this.jPanel12 = new JPanel();
        this.tfOptionsObserver = new JTextField();
        this.buObsItemConfig = JButtonFactory.newButton();
        this.jLabel1 = new JLabel();
        this.buObsItemDelete = JButtonFactory.newButton();
        this.jPanel9 = new JPanel();
        this.jLabel13 = new JLabel();
        this.buAddObserver = JButtonFactory.newButton();
        this.jLabel14 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.listObservers = new ModuleList();
        this.jScrollPane3 = new JScrollPane();
        this.listViews = new ModuleList();
        this.buAddView = JButtonFactory.newButton();
        this.jScrollPane15 = new JScrollPane();
        this.taDescrObserver = new JTextArea();
        this.jScrollPane16 = new JScrollPane();
        this.taDescrView = new JTextArea();
        this.setLayout(new GridBagLayout());
        this.setBorder(new TitledBorder("Add Observers and Views"));
        this.jPanel7.setLayout(new GridBagLayout());
        this.jPanel7.setBorder(new TitledBorder("Current Observer Setup"));
        this.treeObsItems.setBorder(new BevelBorder(1));
        this.treeObsItems.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent evt) {
                PanelObservers.this.treeObsItemsValueChanged(evt);
            }
        });
        this.jScrollPane4.setViewportView(this.treeObsItems);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.jPanel7.add((Component)this.jScrollPane4, gridBagConstraints);
        this.jPanel12.setLayout(new GridBagLayout());
        this.tfOptionsObserver.setEditable(false);
        this.tfOptionsObserver.setText("<no element selected>");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        gridBagConstraints.weightx = 0.1;
        this.jPanel12.add((Component)this.tfOptionsObserver, gridBagConstraints);
        this.buObsItemConfig.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Preferences16.gif")));
        this.buObsItemConfig.setMnemonic('o');
        this.buObsItemConfig.setText("Configure...");
        this.buObsItemConfig.setEnabled(false);
        this.buObsItemConfig.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanelObservers.this.buObsItemConfigActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 5, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.jPanel12.add((Component)this.buObsItemConfig, gridBagConstraints);
        this.jLabel1.setText("Options:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.jPanel12.add((Component)this.jLabel1, gridBagConstraints);
        this.buObsItemDelete.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Delete16.gif")));
        this.buObsItemDelete.setEnabled(false);
        this.buObsItemDelete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanelObservers.this.buObsItemDeleteActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        this.jPanel12.add((Component)this.buObsItemDelete, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.jPanel7.add((Component)this.jPanel12, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        this.add((Component)this.jPanel7, gridBagConstraints);
        this.jPanel9.setLayout(new GridBagLayout());
        this.jPanel9.setMinimumSize(new Dimension(200, 0));
        this.jPanel9.setPreferredSize(new Dimension(200, 0));
        this.jLabel13.setText("Available Observers:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.jPanel9.add((Component)this.jLabel13, gridBagConstraints);
        this.buAddObserver.setFont(new Font("Dialog", 0, 12));
        this.buAddObserver.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Find16.gif")));
        this.buAddObserver.setMnemonic('a');
        this.buAddObserver.setText("Add Observer");
        this.buAddObserver.setEnabled(false);
        this.buAddObserver.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanelObservers.this.buAddObserverActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        this.jPanel9.add((Component)this.buAddObserver, gridBagConstraints);
        this.jLabel14.setText("Available Views:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.jPanel9.add((Component)this.jLabel14, gridBagConstraints);
        this.listObservers.setSelectionMode(0);
        this.listObservers.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                PanelObservers.this.listObserversValueChanged(evt);
            }
        });
        this.listObservers.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                PanelObservers.this.listObserversMouseClicked(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.listObservers);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.jPanel9.add((Component)this.jScrollPane2, gridBagConstraints);
        this.listViews.setEnabled(false);
        this.listViews.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                PanelObservers.this.listViewsValueChanged(evt);
            }
        });
        this.listViews.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                PanelObservers.this.listViewsMouseClicked(evt);
            }
        });
        this.jScrollPane3.setViewportView(this.listViews);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.jPanel9.add((Component)this.jScrollPane3, gridBagConstraints);
        this.buAddView.setFont(new Font("Dialog", 0, 12));
        this.buAddView.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/PrintPreview16.gif")));
        this.buAddView.setMnemonic('u');
        this.buAddView.setText("Add View");
        this.buAddView.setEnabled(false);
        this.buAddView.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanelObservers.this.buAddViewActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        this.jPanel9.add((Component)this.buAddView, gridBagConstraints);
        this.jScrollPane15.setMinimumSize(new Dimension(0, 50));
        this.jScrollPane15.setPreferredSize(new Dimension(0, 50));
        this.taDescrObserver.setEditable(false);
        this.taDescrObserver.setLineWrap(true);
        this.taDescrObserver.setToolTipText("Here you can read the description of the selected observer.");
        this.taDescrObserver.setWrapStyleWord(true);
        this.jScrollPane15.setViewportView(this.taDescrObserver);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.jPanel9.add((Component)this.jScrollPane15, gridBagConstraints);
        this.jScrollPane16.setMinimumSize(new Dimension(0, 50));
        this.jScrollPane16.setPreferredSize(new Dimension(0, 50));
        this.taDescrView.setEditable(false);
        this.taDescrView.setLineWrap(true);
        this.taDescrView.setToolTipText("Here you can read the description of the selected view.");
        this.taDescrView.setWrapStyleWord(true);
        this.jScrollPane16.setViewportView(this.taDescrView);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.jPanel9.add((Component)this.jScrollPane16, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.add((Component)this.jPanel9, gridBagConstraints);
    }

    private void buObsItemConfigActionPerformed(ActionEvent evt) {
        TreePath tp = this.treeObsItems.getSelectionModel().getSelectionPath();
        if (tp != null) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)tp.getLastPathComponent();
            ObserverTreeElement ote = (ObserverTreeElement)node.getUserObject();
            Module m = ote.getModule();
            String s = Util.configureModule(this.scheduleEditor, m, this.schedule);
            if (s != null) {
                Util.displayText(this.tfOptionsObserver, s);
            }
            this.scheduleDependencyChecker.processNewModuleConfiguration(m);
        }
    }

    private void buObsItemDeleteActionPerformed(ActionEvent evt) {
        TreePath path;
        DefaultMutableTreeNode node;
        if (!this.treeObsItems.isSelectionEmpty() && !(node = (DefaultMutableTreeNode)(path = this.treeObsItems.getSelectionPath()).getLastPathComponent()).getUserObject().toString().equals(ObserverTreeElement.getNoViewTreeElement().toString())) {
            this.deleteNode(node);
        }
    }

    private void buAddViewActionPerformed(ActionEvent evt) {
        if (!this.listViews.isSelectionEmpty()) {
            DefaultMutableTreeNode obsNode = null;
            TreePath parentPath = this.treeObsItems.getSelectionPath();
            obsNode = (DefaultMutableTreeNode)parentPath.getPathComponent(1);
            View selectedView = (View)this.listViews.getSelectedValue();
            View v = null;
            try {
                v = (View)this.moduleCollector.newModule(selectedView.getClass(), new Object[]{this.schedule});
            }
            catch (UnsupportedEnvironmentException e) {
                throw new RuntimeException("View " + selectedView.getClass() + " is not supported even though checked before.");
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException("View " + selectedView.getClass() + " could not be instantiated even though checked before.");
            }
            v.createEvents();
            this.addView(v, obsNode);
        }
    }

    private void buAddObserverActionPerformed(ActionEvent evt) {
        if (!this.listObservers.isSelectionEmpty()) {
            Observer selectedObserver = (Observer)this.listObservers.getSelectedValue();
            Observer obs = null;
            try {
                obs = (Observer)this.moduleCollector.newModule(selectedObserver.getClass(), new Object[]{this.schedule});
            }
            catch (UnsupportedEnvironmentException e) {
                throw new RuntimeException("Observer " + selectedObserver.getClass() + " is not supported even though checked before.");
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException("Observer " + selectedObserver.getClass() + " could not be instantiated even though checked before.");
            }
            obs.createEvents();
            this.addObserver(obs);
        }
    }

    private void listViewsMouseClicked(MouseEvent evt) {
        if (this.listViews.isEnabled() && evt.getClickCount() == 2) {
            this.buAddViewActionPerformed(null);
        }
    }

    private void listObserversMouseClicked(MouseEvent evt) {
        if (this.listObservers.isEnabled() && evt.getClickCount() == 2) {
            this.buAddObserverActionPerformed(null);
        }
    }

    private void treeObsItemsValueChanged(TreeSelectionEvent evt) {
        TreePath tp = this.treeObsItems.getSelectionModel().getSelectionPath();
        if (tp != null) {
            this.buObsItemDelete.setEnabled(true);
            DefaultMutableTreeNode obsNode = (DefaultMutableTreeNode)tp.getPath()[1];
            ObserverTreeElement ote = (ObserverTreeElement)obsNode.getUserObject();
            this.createListOfViews((Observer)ote.getModule());
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)tp.getLastPathComponent();
            ote = (ObserverTreeElement)node.getUserObject();
            Module m = ote.getModule();
            if (m instanceof Configurable) {
                this.buObsItemConfig.setEnabled(true);
                Configuration conf = ((Configurable)m).getConfiguration();
                Util.displayText(this.tfOptionsObserver, conf.getDescription());
            } else {
                this.buObsItemConfig.setEnabled(false);
                Util.displayText(this.tfOptionsObserver, "<not configurable>");
            }
            this.buObsItemDelete.setEnabled(true);
        } else {
            this.listViews.setEnabled(false);
            this.buAddView.setEnabled(false);
            this.buObsItemConfig.setEnabled(false);
            this.buObsItemDelete.setEnabled(false);
            Util.displayText(this.tfOptionsObserver, "<no element selected>");
        }
    }

    private void listViewsValueChanged(ListSelectionEvent evt) {
        if (evt.getValueIsAdjusting()) {
            return;
        }
        if (!this.listViews.isSelectionEmpty()) {
            int i = this.listViews.getSelectedIndex();
            Util.displayText(this.taDescrView, this.views[i].getDescription());
        } else {
            Util.displayText(this.taDescrView, "<no view selected>");
        }
    }

    private void listObserversValueChanged(ListSelectionEvent evt) {
        if (evt.getValueIsAdjusting()) {
            return;
        }
        if (!this.listObservers.isSelectionEmpty()) {
            int i = this.listObservers.getSelectedIndex();
            Util.displayText(this.taDescrObserver, this.observers[i].getDescription());
        } else {
            Util.displayText(this.taDescrObserver, "<no observer selected>");
        }
    }
}

