/*
 * Decompiled with CFR 0.152.
 */
package freak.gui;

import freak.core.modulesupport.Module;
import freak.gui.ModuleList;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JPanel;

public class ModuleCheckBoxList
extends ModuleList {
    private JCheckBox[] checkBoxes = new JCheckBox[0];

    public ModuleCheckBoxList() {
        this.setCellRenderer(new ModuleCheckBoxListCellRenderer());
    }

    public void setModules(Module[] modules, Module[] currentModules) {
        DefaultListModel<Module> listModel = new DefaultListModel<Module>();
        boolean[] isSelected = new boolean[modules.length];
        int numberOfSelectedIndices = 0;
        int i = 0;
        while (i < modules.length) {
            Module currentModule = null;
            if (currentModules != null) {
                int j = 0;
                while (j < currentModules.length) {
                    if (currentModules[j] != null && this.sameClass(modules[i], currentModules[j])) {
                        currentModule = currentModules[j];
                    }
                    ++j;
                }
            }
            if (currentModule != null) {
                listModel.addElement(currentModule);
                isSelected[i] = true;
                ++numberOfSelectedIndices;
            } else {
                listModel.addElement(modules[i]);
                isSelected[i] = false;
            }
            ++i;
        }
        this.setModel(listModel);
        this.checkBoxes = new JCheckBox[modules.length];
        i = 0;
        while (i < this.checkBoxes.length) {
            this.checkBoxes[i] = new JCheckBox();
            this.checkBoxes[i].setSelected(isSelected[i]);
            ++i;
        }
    }

    public Object[] getCheckedValues() {
        int number = 0;
        int i = 0;
        while (i < this.checkBoxes.length) {
            if (this.checkBoxes[i].isSelected()) {
                ++number;
            }
            ++i;
        }
        int index = 0;
        Object[] result = new Object[number];
        int i2 = 0;
        while (i2 < this.checkBoxes.length) {
            if (this.checkBoxes[i2].isSelected()) {
                result[index++] = this.getModel().getElementAt(i2);
            }
            ++i2;
        }
        return result;
    }

    public JCheckBox getCheckBox(int i) {
        return this.checkBoxes[i];
    }

    private class ModuleCheckBoxListCellRenderer
    extends DefaultListCellRenderer {
        private String moduleName = "N/A";

        private ModuleCheckBoxListCellRenderer() {
        }

        public String getText() {
            return this.moduleName;
        }

        public Component getListCellRendererComponent(JList arg0, Object arg1, int index, boolean arg3, boolean arg4) {
            this.moduleName = arg1 != null ? ((Module)arg1).getName() : "(none)";
            JPanel panel = new JPanel();
            panel.setLayout(new BorderLayout());
            Component comp = super.getListCellRendererComponent((JList<?>)arg0, arg1, index, arg3, arg4);
            ModuleCheckBoxList.this.checkBoxes[index].setBackground(comp.getBackground());
            panel.add((Component)ModuleCheckBoxList.this.checkBoxes[index], "West");
            panel.add(comp, "Center");
            return panel;
        }
    }
}

