/*
 * Decompiled with CFR 0.152.
 */
package freak.core.modulesupport;

import freak.core.control.Schedule;
import freak.core.graph.FreakGraphModel;
import freak.core.modulesupport.ClassCollector;
import freak.core.modulesupport.ModuleInfo;
import freak.gui.graph.OperatorGraphFile;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;

public class OperatorGraphCollector {
    private Schedule schedule;

    public OperatorGraphCollector(Schedule schedule) {
        this.schedule = schedule;
    }

    private String[] getClassPaths() {
        return System.getProperty("java.class.path").split(System.getProperty("path.separator"));
    }

    private boolean isCorrectOperatorGraph(File file) {
        try {
            return this.isCorrectOperatorGraph(new FileInputStream(file));
        }
        catch (Exception exc) {
            return false;
        }
    }

    private boolean isCorrectOperatorGraph(InputStream fis) {
        try {
            OperatorGraphFile ogFile = OperatorGraphFile.read(fis);
            FreakGraphModel model = ogFile.generateGraph(this.schedule);
            model.getOperatorGraph().testSchedule(this.schedule);
            model.getOperatorGraph().removeFromEventController();
        }
        catch (Exception exc) {
            return false;
        }
        return true;
    }

    public ModuleInfo[] getPredefinedGraphs(String lookFor) {
        ArrayList infos = new ArrayList();
        String[] classpaths = this.getClassPaths();
        String startedFrom = ClassCollector.getStartedFrom();
        if (startedFrom.toLowerCase().endsWith(".jar")) {
            String resDir = String.valueOf(startedFrom.substring(0, startedFrom.lastIndexOf("/") + 1)) + "resource";
            classpaths = new String[]{resDir};
        }
        int cp = 0;
        while (cp < classpaths.length) {
            this.collectFilesInFolder(infos, lookFor, new File(String.valueOf(classpaths[cp]) + "/freak/module/graph/common/"));
            String searchspaceString = this.schedule.getGenotypeSearchSpace().getClass().getName();
            searchspaceString = searchspaceString.substring(searchspaceString.lastIndexOf(".") + 1).toLowerCase();
            this.collectFilesInFolder(infos, lookFor, new File(String.valueOf(classpaths[cp]) + "/freak/module/graph/" + searchspaceString));
            ++cp;
        }
        Object[] o = infos.toArray();
        Arrays.sort(o);
        ModuleInfo[] mi = new ModuleInfo[o.length];
        int i = 0;
        while (i < o.length) {
            mi[i] = (ModuleInfo)o[i];
            ++i;
        }
        return mi;
    }

    private void collectFilesInFolder(ArrayList infos, String lookFor, File graphFolder) {
        File[] allFiles = graphFolder.listFiles(new GraphFileFilter());
        if (allFiles != null) {
            int i = 0;
            while (i < allFiles.length) {
                ModuleInfo info = new ModuleInfo("", "", allFiles[i].getAbsolutePath());
                if ((lookFor == null || lookFor.equals(allFiles[i].getName())) && this.isCorrectOperatorGraph(allFiles[i])) {
                    String name = allFiles[i].getName().substring(0, allFiles[i].getName().indexOf(46));
                    info.setName(name);
                    infos.add(info);
                }
                ++i;
            }
        }
    }

    private class GraphFileFilter
    implements FileFilter {
        private GraphFileFilter() {
        }

        public boolean accept(File pathname) {
            return pathname.getAbsolutePath().endsWith(".fop");
        }
    }
}

