% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RFpredInterval-package.R
\docType{package}
\name{RFpredInterval-package}
\alias{RFpredInterval-package}
\title{RFpredInterval: A package for building prediction intervals with random
forests and boosted forests}
\description{
RFpredInterval provides methods to build prediction intervals with random
forests. The methods provided in the package are Prediction Intervals with
Boosted Forests (PIBF) proposed by Alakus et al. (2021) and 15 distinct
variations to build PIs proposed by Roy and Larocque (2020). RFpredInterval
includes two main functions: \code{pibf} and \code{rfpi}. \code{pibf} applies
the PIBF method and it uses the CRAN package 'ranger' (Wright and Ziegler,
2017) to fit random forests. \code{rfpi} applies the 15 variations proposed
by Roy and Larocque (2020). For \code{rfpi}, RFpredInterval uses
'randomForestSRC' package (Ishwaran and Kogalur, 2021) by freezing at the
version 2.11.0. The custom splitting rule feature is utilised to apply the
splitting rules L1 and SPI. For the least-squares splitting rule, both
'randomForestSRC' and ranger' packages are applicable.
}
\section{RFpredInterval functions}{

\code{\link{pibf}}
\code{\link{rfpi}}
\code{\link{piall}}
\code{\link{plot.pi.piall}}
}

\references{
Alakus, C., Larocque, D., and Labbe, A. (2021). RFpredInterval:
An R Package for Prediction Intervals with Random Forests and Boosted
Forests. arXiv preprint arXiv:2106.08217.

Ishwaran H, Kogalur U (2021). Fast Unified Random Forests for
Survival, Regression, and Classification (RF-SRC). R package version
2.11.0, \url{https://cran.r-project.org/package=randomForestSRC}.

Roy, M. H., & Larocque, D. (2020). Prediction intervals with
random forests. Statistical methods in medical research, 29(1), 205-229.
doi:10.1177/0962280219829885.

Wright MN, Ziegler A (2017). “ranger: A Fast Implementation of
Random Forests for High Dimensional Data in C++ and R.” Journal of
Statistical Software, 77(1), 1–17.
doi:10.18637/jss.v077.i01.
}
