% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{dataCopCont2}
\alias{dataCopCont2}
\title{Simulated Dataset with Two Endogenous Continuous Regressor}
\format{
A data frame with 2500 observations on 5 variables:
\describe{
\item{\code{y}}{a numeric vector representing the dependent variable.}
\item{\code{X1}}{a numeric vector, normally distributed and exogenous.}
\item{\code{X2}}{a numeric vector, normally distributed and exogenous.}
\item{\code{P1}}{a numeric vector, continuous and endogenous having T-distribution with 3 degrees of freedom.}
\item{\code{P2}}{a numeric vector, continuous and endogenous having T-distribution with 3 degrees of freedom.}
}
}
\usage{
data("dataCopCont2")
}
\description{
A dataset with two exogenous regressors,
 \code{X1},\code{X2}, and two endogenous, continuous regressors,
 \code{P1} and \code{P2}, having a T-distribution with 3 degrees of freedom.
 An intercept and a dependent variable, \code{y}, are also included.
 The true parameter values for the intercept and the exogenous regressors' coefficients are: \code{b0 = 2}, \code{b1 = 1.5},
 \code{b2 = -3}. The coefficient of the endogenous regressor \code{P1} is equal to \code{a1 = -1} and
 of \code{P2} is equal to \code{a2 = 0.8}.
}
\author{
Raluca Gui \email{raluca.gui@business.uzh.ch}
}
\keyword{datasets}
