% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S2chisq.R
\name{S2chisq}
\alias{S2chisq}
\title{Convert non-zero S to Chi-square statistic}
\usage{
S2chisq(S, df, n)
}
\arguments{
\item{S}{The value of the RESI estimate.}

\item{df}{Number of degrees of freedom of the chi-square statistic.}

\item{n}{Number of independent samples.}
}
\value{
Returns a scalar or vector argument of the Chi-square statistic.
}
\description{
Converts the robust effect size index (S) to Chi-square statistic, given that S is greater than 0.
For an S value of 0, only an upper bound on the Chi-square statistic can be computed.
Vector arguments are accepted. If different length arguments are passed they are dealt with in the usual way of R.
}
\details{
The formula for converting a RESI estimate above 0 to Chi-square statistic is:

\eqn{ chisq = n*S^2 + df}

If the RESI estimate is 0, all that is known is that the Chi-square statistic is less than or equal to the degrees of freedom.
}
\examples{
# convert S estimates with corresponding degrees of freedom to Chi-square estimates
S_ests = c(0.2, 0.4, 0.6)
dfs = c(2, 1, 3)
S2chisq(S = S_ests, df = dfs, n = 300)

}
