% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/d2S.R
\name{d2S}
\alias{d2S}
\title{Covert Cohen's \emph{d} to |S|}
\usage{
d2S(d, pi = 0.5)
}
\arguments{
\item{d}{Numeric, value of Cohen's \emph{d}.}

\item{pi}{Numeric, the sampling proportions.}
}
\value{
Returns an estimate the robust effect size index
}
\description{
Converts Cohen's \emph{d} robust effect size index (S) using the formula from
Vandekar, Rao, & Blume (2020).
}
\details{
The pi parameter comes from the fact that Cohen's d doesn't account
for unequal sample proportions in the population, but S does.

The default is set to a natural value 1/2, which corresponds to a case
control design, for example, where sampling proportions always are
controlled by the experimenter.

The formula to convert Cohen's \emph{d} to S is:

\eqn{S = d/\sqrt( 1/\pi + 1/ (1 - \pi))}
}
\examples{
# Consider an experiment with equal sampling proportions and a medium effect size
# corresponding to a Cohen's d of 0.5.
# convert to RESI (S)
d2S(d = 0.5)

# This corresponds to a RESI of 0.25.
}
