/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdistmulti;

import umontreal.iro.lecuyer.probdist.NormalDist;
import umontreal.iro.lecuyer.probdistmulti.BiNormalDist;

public class BiNormalGenzDist
extends BiNormalDist {
    private static final double[][] W = new double[][]{{0.1713244923791705, 0.3607615730481384, 0.4679139345726904}, {0.04717533638651177, 0.1069393259953183, 0.1600783285433464, 0.2031674267230659, 0.2334925365383547, 0.2491470458134029}, {0.01761400713915212, 0.04060142980038694, 0.06267204833410905, 0.08327674157670475, 0.1019301198172404, 0.1181945319615184, 0.1316886384491766, 0.1420961093183821, 0.1491729864726037, 0.1527533871307259}};
    private static final double[][] X = new double[][]{{0.9324695142031522, 0.6612093864662647, 0.238619186083197}, {0.9815606342467191, 0.904117256370475, 0.769902674194305, 0.5873179542866171, 0.3678314989981802, 0.1252334085114692}, {0.9931285991850949, 0.9639719272779138, 0.912234428251326, 0.8391169718222188, 0.7463319064601508, 0.636053680726515, 0.5108670019508271, 0.3737060887154196, 0.2277858511416451, 0.07652652113349732}};

    public BiNormalGenzDist(double d) {
        super(d);
    }

    public BiNormalGenzDist(double d, double d2, double d3, double d4, double d5) {
        super(d, d2, d3, d4, d5);
    }

    public static double cdf(double d, double d2, double d3) {
        int n;
        int n2;
        double d4 = BiNormalGenzDist.specialCDF(d, d2, d3, 40.0);
        if (d4 >= 0.0) {
            return d4;
        }
        if (Math.abs(d3) < 0.3) {
            n2 = 0;
            n = 3;
        } else if (Math.abs(d3) < 0.75) {
            n2 = 1;
            n = 6;
        } else {
            n2 = 2;
            n = 10;
        }
        double d5 = -d;
        double d6 = -d2;
        double d7 = d5 * d6;
        d4 = 0.0;
        if (Math.abs(d3) < 0.925) {
            double d8 = (d5 * d5 + d6 * d6) / 2.0;
            double d9 = Math.asin(d3);
            for (int i = 0; i < n; ++i) {
                double d10 = Math.sin(d9 * (1.0 - X[n2][i]) / 2.0);
                d4 += W[n2][i] * Math.exp((d10 * d7 - d8) / (1.0 - d10 * d10));
                d10 = Math.sin(d9 * (1.0 + X[n2][i]) / 2.0);
                d4 += W[n2][i] * Math.exp((d10 * d7 - d8) / (1.0 - d10 * d10));
            }
            d4 = d4 * d9 / (Math.PI * 4) + NormalDist.cdf01(-d5) * NormalDist.cdf01(-d6);
        } else {
            double d11;
            if (d3 < 0.0) {
                d6 = -d6;
                d7 = -d7;
            }
            if (Math.abs(d3) < 1.0) {
                double d12;
                double d13 = (1.0 - d3) * (1.0 + d3);
                double d14 = Math.sqrt(d13);
                double d15 = (d5 - d6) * (d5 - d6);
                double d16 = (4.0 - d7) / 8.0;
                double d17 = (12.0 - d7) / 16.0;
                double d18 = -(d15 / d13 + d7) / 2.0;
                if (d18 > -100.0) {
                    d4 = d14 * Math.exp(d18) * (1.0 - d16 * (d15 - d13) * (1.0 - d17 * d15 / 5.0) / 3.0 + d16 * d17 * d13 * d13 / 5.0);
                }
                if (-d7 < 100.0) {
                    double d19 = Math.sqrt(d15);
                    d12 = 2.5066282746310007 * NormalDist.cdf01(-d19 / d14);
                    d4 -= Math.exp(-d7 / 2.0) * d12 * d19 * (1.0 - d16 * d15 * (1.0 - d17 * d15 / 5.0) / 3.0);
                }
                d14 /= 2.0;
                for (int i = 0; i < n; ++i) {
                    for (int j = -1; j <= 1; j += 2) {
                        d11 = d14 * ((double)j * X[n2][i] + 1.0);
                        d11 *= d11;
                        double d20 = Math.sqrt(1.0 - d11);
                        d18 = -(d15 / d11 + d7) / 2.0;
                        if (!(d18 > -100.0)) continue;
                        d12 = 1.0 + d16 * d11 * (1.0 + d17 * d11);
                        double d21 = Math.exp(-d7 * (1.0 - d20) / (2.0 * (1.0 + d20))) / d20;
                        d4 += d14 * W[n2][i] * Math.exp(d18) * (d21 - d12);
                    }
                }
                d4 = -d4 / (Math.PI * 2);
            }
            if (d3 > 0.0) {
                if (d6 > d5) {
                    d5 = d6;
                }
                d4 += NormalDist.cdf01(-d5);
            }
            if (d3 < 0.0) {
                d11 = NormalDist.cdf01(-d5) - NormalDist.cdf01(-d6);
                if (d11 < 0.0) {
                    d11 = 0.0;
                }
                d4 = -d4 + d11;
            }
        }
        if (d4 <= 0.0) {
            return 0.0;
        }
        if (d4 >= 1.0) {
            return 1.0;
        }
        return d4;
    }

    public static double cdf(double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("sigma1 <= 0");
        }
        if (d5 <= 0.0) {
            throw new IllegalArgumentException("sigma2 <= 0");
        }
        double d8 = (d3 - d) / d2;
        double d9 = (d6 - d4) / d5;
        return BiNormalGenzDist.cdf(d8, d9, d7);
    }

    public double cdf(double d, double d2) {
        return BiNormalGenzDist.cdf((d - this.mu1) / this.sigma1, (d2 - this.mu2) / this.sigma2, this.rho);
    }

    public double barF(double d, double d2) {
        return BiNormalGenzDist.barF((d - this.mu1) / this.sigma1, (d2 - this.mu2) / this.sigma2, this.rho);
    }

    public static double barF(double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("sigma1 <= 0");
        }
        if (d5 <= 0.0) {
            throw new IllegalArgumentException("sigma2 <= 0");
        }
        double d8 = (d3 - d) / d2;
        double d9 = (d6 - d4) / d5;
        return BiNormalGenzDist.barF(d8, d9, d7);
    }

    public static double barF(double d, double d2, double d3) {
        return BiNormalGenzDist.cdf(-d, -d2, d3);
    }
}

