% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{update_field_names}
\alias{update_field_names}
\title{Update metadata field names for checkbox handling}
\usage{
update_field_names(db_metadata)
}
\arguments{
\item{db_metadata}{The REDCap metadata output defined by
\code{REDCapR::redcap_metadata_read()$data}}
}
\value{
Column \code{db_metadata} with \code{field_name_updated} appended
and \code{field_label} updated for new rows corresponding to checkbox options
}
\description{
Takes a \code{db_metadata} object and:
\itemize{
\item replaces checkbox field rows with a set of rows, one for each
checkbox option
\item appends a \code{field_name_updated} field to the end for checkbox
variable handling
\item updates \code{field_label} for any new checkbox rows to include the
specific option in "field_label: option label" format
\item strips html and field embedding logic from \code{field_label}
}
}
\details{
Assumes \code{db_metadata}:
\itemize{
\item has non-zero number of rows
\item contains \code{field_name} and \code{field_label} columns
}
}
\keyword{internal}
