% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redcap-metadata-read.R
\name{to_api_array}
\alias{to_api_array}
\title{Convert a vector to the array format expected by the REDCap API}
\usage{
to_api_array(x, element_names)
}
\arguments{
\item{x}{A vector to convert to array format.  Can be \code{NULL}.}

\item{element_names}{A string containing the name of the API request parameter for
the array.  Must be either "fields" or "forms".}
}
\value{
If \code{x} is not \code{NULL} a list is returned with one element for
each element of x in the format:
\code{list(`element_names[0]` = x[1], `element_names[1]` = x[2], ...)}.

If \code{x} is \code{NULL} then \code{NULL} is returned.
}
\description{
Utility function to convert a vector into the array format expected by the
some REDCap API calls.  It is called internally by REDCapR functions,
and is not intended to be called directly.
}
