% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{Finv}
\alias{Finv}
\title{Function inversion}
\usage{
Finv(y, F, interval = c(0, 1), ...)
}
\arguments{
\item{y}{the scalar at which to evaluate the inverse}

\item{F}{the function}

\item{interval}{the domain within which to begin looking}

\item{...}{other arguments for the function F}
}
\description{
Given a function, F(x, ...), and a scalar y, find
x such that F(x, ...) = y.  Note that there is no
checking for the monotonicity of F wrt to x, or that
the interval specified is appropriate to the problem.
Such fine points are entirely the responsibility of
the user/abuser.  If the interval specified doesn't
contain a root some automatic attempt to expand the
interval will be made.  Originally intended for use 
with F as \code{ThreshFDR}.
}
\author{
R. Koenker
}
\keyword{utility}
