

library(testthat)
library(RDS)

context("rds-ss.R")

test_that("rds-ss",{
  data(faux)
  
  e1 <- structure(list(estimate = structure(c(0.308679056967587, 0.691320943032413
  ), .Names = c("blue", "red")), interval = structure(c(0.308679056967587, 
                                                        0.691320943032413, 0.2541430410081, 0.636784927072925, 0.363215072927075, 
                                                        0.7458569589919, 2.30749981181808, 2.30749981181808, 0.0278244979385139, 
                                                        0.0278244979385139, 118, 271), .Dim = c(2L, 6L), .Dimnames = list(
                                                          c("blue", "red"), c("point", "lower", "upper", "Design Effect", 
                                                                              "s.e.", "n")), .Names = c("blue", "red", NA, NA, NA, NA, 
                                                                                                        NA, NA, NA, NA, NA, NA)), outcome.variable = "X", weight.type = "Gile's SS", 
  uncertainty = "EL", weights = structure(c(2.4485189841449, 
                                            2.06602034409758, 2.2991362373178, 1.51138361195204, 2.69696322434054, 
                                            1.77622321053674, 1.31914622271253, 1.65232983809068, 3.28205677765961, 
                                            3.55902913173124, 1.74188420141963, 1.97611917725661, 1.65232983809068, 
                                            1.96042285394477, 1.96042285394477, 2.20846094829233, 1.862964933934, 
                                            2.12916139585485, 1.61939242611993, 2.54936123939949, 1.77622321053674, 
                                            1.83281742095342, 2.54936123939949, 2.83567000215393, 1.31568389666866, 
                                            1.74188420141963, 2.2991362373178, 1.97611917725661, 2.4485189841449, 
                                            2.54936123939949, 1.97611917725661, 1.862964933934, 2.12916139585485, 
                                            2.12916139585485, 2.69696322434054, 2.20846094829233, 1.48306380068272, 
                                            2.2991362373178, 1.49634496904705, 2.83567000215393, 2.2991362373178, 
                                            2.54936123939949, 2.20846094829233, 2.83567000215393, 2.2991362373178, 
                                            2.4485189841449, 2.06602034409758, 2.06602034409758, 1.74188420141963, 
                                            2.2991362373178, 1.97611917725661, 2.69696322434054, 2.69696322434054, 
                                            1.83281742095342, 1.68906030762892, 2.20846094829233, 2.06602034409758, 
                                            2.4485189841449, 2.4485189841449, 1.77622321053674, 4.22963273659297, 
                                            2.4485189841449, 1.49634496904705, 1.97611917725661, 1.51138361195204, 
                                            3.95157747666502, 2.54936123939949, 2.2991362373178, 2.12916139585485, 
                                            2.54936123939949, 1.54619236468464, 2.54936123939949, 2.12916139585485, 
                                            1.83281742095342, 1.862964933934, 2.20846094829233, 2.83567000215393, 
                                            1.96042285394477, 2.20846094829233, 2.06602034409758, 1.54619236468464, 
                                            1.83281742095342, 2.20846094829233, 1.97611917725661, 2.69696322434054, 
                                            2.83567000215393, 2.06602034409758, 1.96042285394477, 4.22963273659297, 
                                            2.54936123939949, 1.96042285394477, 1.97611917725661, 2.54936123939949, 
                                            2.12916139585485, 2.83567000215393, 1.51138361195204, 1.97611917725661, 
                                            1.61939242611993, 1.31914622271253, 2.54936123939949, 1.61939242611993, 
                                            2.69696322434054, 3.00788476353561, 2.2991362373178, 2.06602034409758, 
                                            2.4485189841449, 2.4485189841449, 1.96042285394477, 1.68906030762892, 
                                            3.00788476353561, 6.68367419507681, 2.69696322434054, 2.83567000215393, 
                                            1.83281742095342, 2.12916139585485, 1.96042285394477, 1.97611917725661, 
                                            2.69696322434054, 4.22963273659297, 2.69696322434054, 2.69696322434054, 
                                            5.54731510154766, 5.54731510154766, 1.77622321053674, 1.61939242611993, 
                                            4.22963273659297, 2.20846094829233, 3.55902913173124, 3.95157747666502, 
                                            4.22963273659297, 2.69696322434054, 2.69696322434054, 1.862964933934, 
                                            1.74188420141963, 4.22963273659297, 3.28205677765961, 1.61939242611993, 
                                            2.83567000215393, 2.20846094829233, 5.54731510154766, 3.28205677765961, 
                                            2.12916139585485, 1.96042285394477, 1.96042285394477, 3.95157747666502, 
                                            2.83567000215393, 2.83567000215393, 2.69696322434054, 2.06602034409758, 
                                            2.4485189841449, 3.55902913173124, 3.95157747666502, 1.97611917725661, 
                                            2.4485189841449, 1.862964933934, 1.862964933934, 2.54936123939949, 
                                            2.54936123939949, 2.69696322434054, 1.61939242611993, 3.00788476353561, 
                                            1.862964933934, 4.75593514829944, 2.2991362373178, 2.69696322434054, 
                                            2.4485189841449, 2.20846094829233, 2.54936123939949, 2.69696322434054, 
                                            3.00788476353561, 7.65052288421201, 7.65052288421201, 1.96042285394477, 
                                            2.2991362373178, 3.55902913173124, 2.2991362373178, 2.20846094829233, 
                                            1.65232983809068, 1.58380905096607, 2.69696322434054, 1.96042285394477, 
                                            2.20846094829233, 3.28205677765961, 1.96042285394477, 3.00788476353561, 
                                            2.4485189841449, 3.00788476353561, 2.69696322434054, 1.97611917725661, 
                                            1.862964933934, 1.65232983809068, 2.54936123939949, 2.20846094829233, 
                                            1.83281742095342, 3.95157747666502, 3.28205677765961, 1.65232983809068, 
                                            2.83567000215393, 2.4485189841449, 3.00788476353561, 1.77622321053674, 
                                            2.83567000215393, 3.28205677765961, 1.96042285394477, 2.20846094829233, 
                                            2.2991362373178, 2.4485189841449, 6.68367419507681, 2.69696322434054, 
                                            2.54936123939949, 2.2991362373178, 1.77622321053674, 3.00788476353561, 
                                            2.54936123939949, 1.77622321053674, 2.54936123939949, 3.00788476353561, 
                                            2.83567000215393, 2.54936123939949, 3.95157747666502, 2.83567000215393, 
                                            2.54936123939949, 1.38092442047042, 2.4485189841449, 3.55902913173124, 
                                            2.69696322434054, 2.54936123939949, 2.2991362373178, 1.83281742095342, 
                                            1.74188420141963, 2.06602034409758, 2.2991362373178, 2.83567000215393, 
                                            2.69696322434054, 1.97611917725661, 3.00788476353561, 2.2991362373178, 
                                            2.54936123939949, 2.2991362373178, 3.28205677765961, 2.69696322434054, 
                                            2.4485189841449, 3.00788476353561, 1.862964933934, 2.69696322434054, 
                                            2.83567000215393, 4.75593514829944, 2.12916139585485, 3.28205677765961, 
                                            2.83567000215393, 2.54936123939949, 2.06602034409758, 2.4485189841449, 
                                            2.06602034409758, 1.96042285394477, 2.2991362373178, 1.83281742095342, 
                                            2.12916139585485, 2.4485189841449, 3.00788476353561, 1.862964933934, 
                                            1.83281742095342, 2.06602034409758, 5.54731510154766, 2.83567000215393, 
                                            2.4485189841449, 2.06602034409758, 2.06602034409758, 2.4485189841449, 
                                            2.54936123939949, 2.69696322434054, 1.96042285394477, 2.54936123939949, 
                                            1.96042285394477, 2.2991362373178, 2.4485189841449, 3.95157747666502, 
                                            1.61939242611993, 1.68906030762892, 2.54936123939949, 2.69696322434054, 
                                            2.54936123939949, 2.06602034409758, 2.54936123939949, 2.83567000215393, 
                                            2.54936123939949, 2.2991362373178, 2.20846094829233, 2.54936123939949, 
                                            1.96042285394477, 2.2991362373178, 2.83567000215393, 2.83567000215393, 
                                            2.83567000215393, 3.28205677765961, 2.54936123939949, 3.95157747666502, 
                                            2.54936123939949, 2.69696322434054, 2.2991362373178, 2.69696322434054, 
                                            2.83567000215393, 2.83567000215393, 2.69696322434054, 3.28205677765961, 
                                            1.54619236468464, 2.2991362373178, 2.54936123939949, 2.83567000215393, 
                                            2.54936123939949, 3.00788476353561, 3.95157747666502, 2.4485189841449, 
                                            1.51138361195204, 2.2991362373178, 3.55902913173124, 2.06602034409758, 
                                            2.12916139585485, 3.55902913173124, 2.20846094829233, 2.2991362373178, 
                                            1.96042285394477, 3.95157747666502, 2.4485189841449, 2.20846094829233, 
                                            1.97611917725661, 3.95157747666502, 4.22963273659297, 2.12916139585485, 
                                            2.2991362373178, 3.00788476353561, 6.68367419507681, 3.55902913173124, 
                                            2.83567000215393, 2.4485189841449, 3.00788476353561, 3.95157747666502, 
                                            3.55902913173124, 2.20846094829233, 1.862964933934, 2.2991362373178, 
                                            2.4485189841449, 2.12916139585485, 3.55902913173124, 4.22963273659297, 
                                            3.28205677765961, 2.2991362373178, 3.00788476353561, 2.20846094829233, 
                                            1.96042285394477, 3.28205677765961, 3.28205677765961, 1.862964933934, 
                                            1.862964933934, 2.4485189841449, 2.2991362373178, 1.97611917725661, 
                                            1.862964933934, 3.28205677765961, 1.97611917725661, 2.4485189841449, 
                                            2.12916139585485, 7.65052288421201, 2.2991362373178, 2.4485189841449, 
                                            3.95157747666502, 2.4485189841449, 1.96042285394477, 1.68906030762892, 
                                            3.00788476353561, 3.28205677765961, 1.96042285394477, 2.54936123939949, 
                                            3.95157747666502, 1.83281742095342, 1.68906030762892, 2.06602034409758, 
                                            2.83567000215393, 3.28205677765961, 2.2991362373178, 2.83567000215393, 
                                            3.55902913173124, 2.20846094829233, 1.96042285394477, 2.20846094829233, 
                                            2.4485189841449, 1.77622321053674, 3.28205677765961, 2.20846094829233
  ), N = 1000, estimateN = 1000), N = 1000, conf.level = 0.95), .Names = c("estimate", 
                                                                           "interval", "outcome.variable", "weight.type", "uncertainty", 
                                                                           "weights", "N", "conf.level"), class = "rds.interval.estimate")
  
  set.seed(1)
  est <- RDS.SS.estimates(rds.data=faux,outcome.variable='X',N=1000)
  s <- mean(abs(est$estimate-e1$estimate))
  expect_true(s<.001)
  s <- mean(abs(est$weights-e1$weights))
  expect_true(s < .05)
  s <- mean(abs(est$interval-e1$interval))
  expect_true(s<.01)
})

