% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CIprop.r
\name{CIprop}
\alias{CIprop}
\title{Confidence intervals of a dataset variable's sample proportions in table and figure}
\usage{
CIprop(x, w, data, digits = 3, level = 95, printC = FALSE, plot = TRUE,
  main, xlab, xlim, ...)
}
\arguments{
\item{x}{A nominal or ordinal variable (factor), should be in dataset$var form unless dataset specified in optional data argument.}

\item{w}{(Optional) Sampling weights of variable, must be numeric; should be in dataset$weightvar form unless dataset specified in optional data argument.}

\item{data}{(Optional) Name of dataset that contains x (and w) variable.}

\item{digits}{(Optional) Number of decimal places reported in result (defaults to 3).}

\item{level}{(Optional) A single number equal to the desired confidence level (i.e. 95, 99, 90, etc.). Default value is 95 percent confidence level.}

\item{printC}{(Optional) Do you want results printed to .html file in your working directory? Default is FALSE. Set to TRUE to print results.}

\item{plot}{(Optional) Do you want a plot of the confidence interval? Default is TRUE.}

\item{main}{(Optional) Change the main title of plot. Default title generated from level, x, and w.}

\item{xlab}{(Optional) Label for x-axis of confidence interval plot.}

\item{xlim}{(Optional) Modify x-axis limits of confidence interval plot.}

\item{...}{(Optional) Additional arguments passed to \code{plot} function.}
}
\value{
Returns a data frame that gives the lower bound, point estimate, and upper bounds of each value of x variable.
}
\description{
Reports the confidence interval of sample proportions in table and plot. Default is 95\% CI but use can raise or lower confidence level.
}
\section{Textbook References}{

\itemize{
\item Philip H. Pollock and Barry C. Edwards, \emph{An R Companion to Political Analysis, 3rd Edition} (Thousand Oaks, CA: Sage Publications, Forthcoming 2022), Chapter 8.
\item Philip H. Pollock and Barry C. Edwards, \emph{The Essentials of Political Analysis, 6th Edition} (Thousand Oaks, CA: Sage Publications, 2020), pp. 184-186. ISBN-13: 978-1506379616; ISBN-10: 150637961.
}
}

\section{Online Resources}{

\itemize{
\item \href{https://www.poliscidata.com/pages/rDemosResources.php?chapter=8}{R Tutorials & Resources for Foundations of Inference}, Compiled by Barry C. Edwards
\item \href{https://edge.sagepub.com/pollock}{Sage Edge Resources for Political Analysis Series}, for streaming videos, flashcards, and more student resources for textbooks by Pollock and Edwards, from Sage Publications.
\item \href{https://www.poliscidata.com}{Political Science Data Web Site}: Find datasets for your own research and resources to help with the analysis.
}
}

\examples{
 
  library(RCPA3)

  CIprop(nes$lifex.knowimmig)
  
  \donttest{
  # using optional w and data arguments
  CIprop(x=nes$lifex.knowimmig, w=nes$wt)
  CIprop(x=lifex.knowimmig, w=wt, data=nes)
  }
}
