% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geneset-analysis.R
\name{runGeneSetAnalysis}
\alias{runGeneSetAnalysis}
\title{Gene Set Enrichment Analysis}
\usage{
runGeneSetAnalysis(
  summarizedExperiment,
  genesets,
  method = c("ora", "fgsea", "gsa", "ks", "wilcox"),
  ORAArgs = list(pThreshold = 0.05),
  FgseaArgs = list(sampleSize = 101, minSize = 1, maxSize = Inf, eps = 1e-50, scoreType =
    "std", nproc = 0, gseaParam = 1, BPPARAM = NULL, nPermSimple = 1000, absEps = NULL),
  GSAArgs = list(method = "maxmean", random.seed = NULL, knn.neighbors = 10, s0 = NULL,
    s0.perc = NULL, minsize = 15, maxsize = 500, restand = TRUE, restand.basis =
    "catalog", nperms = 200, xl.mode = "regular", xl.time = NULL, xl.prevfit = NULL)
)
}
\arguments{
\item{summarizedExperiment}{The generated SummarizedExpriment object from DE analysis result.}

\item{genesets}{The gene sets definition, ex. KEGG genesets from getGeneSets function.}

\item{method}{The gene set enrichment analsyis method, including ORA, fgsea, GSA, ks, and wilcox.}

\item{ORAArgs}{A list of other passed arguments to ORA. pThreshold is used as p.value cutoff to pick DE genes.}

\item{FgseaArgs}{A list of other passed arguments to fgsea. See fgsea function.}

\item{GSAArgs}{A list of other passed arguments to GSA. See GSA function.}
}
\value{
A dataframe of gene set enrichment analysis result, which contains the following columns:
\itemize{
\item{ID: The ID of the gene set}
\item{p.value: The p-value of the gene set}
\item{pFDR: The adjusted p-value of the gene set using the Benjamini-Hochberg method}
\item{score: The enrichment score of the gene set}
\item{normalizedScore: The normalized enrichment score of the gene set}
\item{sampleSize: The total number of samples in the study}
\item{name: The name of the gene set}
\item{pathwaySize: The size of the gene set}
}

The returned data frame is sorted based on the pathways' nominal p-values.
}
\description{
This function performs gene set enrichment analysis using either ORA, fgsea, GSA, ks, or wilcox approaches.
}
\examples{
\donttest{

library(RCPA)

RNASeqDEExperiment <- loadData("RNASeqDEExperiment")
genesets <- loadData("genesets")

oraResult <- runGeneSetAnalysis(RNASeqDEExperiment, genesets,
                               method = "ora", 
                               ORAArgs = list(pThreshold = 0.05))
print(head(oraResult))
                                           
fgseaResult <- runGeneSetAnalysis(RNASeqDEExperiment, genesets, 
                               method = "fgsea",
                               FgseaArgs = list(minSize = 10, maxSize = Inf))
print(head(fgseaResult))

}
}
