% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/likelihood.R
\name{likelihood}
\alias{likelihood}
\alias{likelihood<-}
\title{Read and Set Likelihood to the Corresponding Conjugate Prior}
\usage{
likelihood(mix)

likelihood(mix) <- value
}
\arguments{
\item{mix}{Prior mixture distribution.}

\item{value}{New likelihood. \strong{Should} only be changed for Gamma priors as these are supported
with either Poisson (\code{value="poisson"}) or Exponential (\code{value="exp"}) likelihoods.}
}
\description{
Read and set the likelihood distribution corresponding to the conjugate prior distribution.
}
\details{
If the prior and posterior distributions are in the same family, then the prior distribution
is called a conjugate prior for the likelihood function.
}
\section{Supported Conjugate Prior-Likelihood Pairs}{


\tabular{lccc}{
\strong{Prior/Posterior} \tab \strong{Likelihood} \tab \strong{Predictive} 
 \tab \strong{Summaries} \cr
Beta \tab Binomial \tab Beta-Binomial \tab \code{n}, \code{r} \cr
Normal \tab Normal (\emph{fixed \eqn{\sigma}}) \tab Normal \tab \code{n}, \code{m}, \code{se}  \cr
Gamma \tab Poisson \tab Gamma-Poisson \tab  \code{n}, \code{m} \cr
Gamma \tab Exponential \tab Gamma-Exp (\emph{not supported}) \tab \code{n}, \code{m}
}
}

\examples{

# Gamma mixture
gmix <- mixgamma(c(0.3, 20, 4), c(0.7, 50, 10))

# read out conjugate partner
likelihood(gmix)

ess(gmix)

# set conjugate partner
likelihood(gmix) <- "exp"

# ... which changes the interpretation of the mixture
ess(gmix)
}
