% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AQSAPI.R
\name{aqs_monitors_by_box}
\alias{aqs_monitors_by_box}
\title{aqs_monitors_by_box}
\usage{
aqs_monitors_by_box(
  parameter,
  bdate,
  edate,
  minlat,
  maxlat,
  minlon,
  maxlon,
  return_header = FALSE
)
}
\arguments{
\item{parameter}{a character list or a single character string
which represents the parameter code of the air
pollutant related to the data being requested.}

\item{bdate}{a R date object which represents that begin date of the data
selection. Only data on or after this date will be returned.}

\item{edate}{a R date object which represents that end date of the data
selection. Only data on or before this date will be returned.}

\item{minlat}{a R character object which represents the minimum latitude of
a geographic box.  Decimal latitude with north begin
positive. Only data north of this latitude will be
returned.}

\item{maxlat}{a R character object which represents the maximum latitude of
a geographic box. Decimal latitude with north begin
positive. Only data south of this latitude will be
returned.}

\item{minlon}{a R character object which represents the minimum longitude
of a geographic box. Decimal longitude with east begin
positive. Only data east of this longitude will be
returned.}

\item{maxlon}{a R character object which represents the maximum longitude
of a geographic box. Decimal longitude with east begin
positive. Only data west of this longitude will be
returned. Note that -80 is less than -70.}

\item{return_header}{If FALSE (default) only returns data requested. If TRUE
returns a AQSAPI_v2 object which is a two item list that contains header
information returned from the API server mostly used for debugging
purposes in addition to the data requested.}
}
\value{
a tibble or an AQS_Data Mart_APIv2 S3 object of monitors from a
latitude/longitude bounding box (_by_box).
}
\description{
\lifecycle{stable}
Returns a table of monitors at all sites with the provided
parameternum, aggregated by latitude/longitude bounding box (_by_box) for
bdate - edate time frame.
}
\section{by_box aggregate functions}{
NA
}

\examples{
#  returns a tibble of all ozone
          #  monitors in the vicinity of central Alabama that operated in
          #  1995
          \dontrun{aqs_monitors_by_box(parameter="44201",
                                               bdate=as.Date("19950101",
                                                           format="\%Y\%m\%d"),
                                               edate=as.Date("19951231",
                                                            format="\%Y\%m\%d"),
                                               minlat="33.3",
                                               maxlat="33.6",
                                               minlon="-87.0",
                                               maxlon="-86.7"
                                                   )
                   }
}
\seealso{
Other Aggregate _by_box functions: 
\code{\link{aqs_annualsummary_by_box}()},
\code{\link{aqs_sampledata_by_box}()}
}
\concept{Aggregate _by_box functions}
