% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ltx_doc.r
\name{ltx_doc}
\alias{ltx_doc}
\title{Prints latex code for a table, listing, plot, or text to a a file or console}
\usage{
ltx_doc(text, out = NULL, template = paste0(system.file(package = "R3port"),
  "/simple.tex"), rendlist, orientation = "landscape", rtitle = "report",
  compile = TRUE, show = TRUE)
}
\arguments{
\item{text}{character vector to be placed within latex document}

\item{out}{filename for the output latex file (if NULL it will print to console)}

\item{template}{file name of the template file to use (see examples how templates can be used/adapted)}

\item{rendlist}{a render list to be used for the template file (see (see \code{\link{whisker-package}}))}

\item{orientation}{string indicating the page orientation (can be either "landscape" or "portrait")}

\item{rtitle}{string indicating the title of the output document}

\item{compile}{logical indicating if the tex file should be compiled (using tools::texi2dvi)}

\item{show}{logical indicating if the resulting pdf file from the compiled tex file should be opened when created}
}
\value{
The function returns a latex file (or writes output to console)
}
\description{
This function makes a latex document using output generated with functions in the R3port package
or any other latex code available as vector. Basically it adds a preamble to a tex file and let's
the user select various options to customize the output.
}
\examples{

\dontrun{
  txt <- "\\\\section{example}"
  tbl <- "\\\\begin{tabular}{|l|c|r|} 1 & 2 & 3 \\\\\\\\ 4 & 5 & 6 \\\\\\\\ \\\\end{tabular}"
  add <- "\\\\\\\\ Including some additional text"
  ltx_doc(c(txt,tbl,add),out=paste0(tempfile(),".tex"),show=FALSE)

  # You can use xtable (and any other packages that output tex)
  library(xtable)
  data(Theoph)
  xtbl <- print(xtable(Theoph),tabular.environment="longtable",floating=FALSE,print.results=FALSE)
  ltx_doc(xtbl,out=tempfile(fileext = ".tex"))

}
}
\seealso{
\code{\link{html_doc}}
}
