% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/df2matrix.R
\name{df2matrix}
\alias{df2matrix}
\title{Translates a data.frame, formatted for use in multiple membership
modelling in MLwiN, to a matrix.}
\usage{
df2matrix(data, idcols, weightcols)
}
\arguments{
\item{data}{A \code{\link[base]{data.frame}} object.}

\item{idcols}{String vector of the identifier column names.}

\item{weightcols}{String vector of the weight column names.}
}
\value{
An adjacency matrix as returned by \code{\link[Matrix]{sparseMatrix}}.
}
\description{
Translates a \code{\link[base]{data.frame}}, in a form usable by MLwiN for multiple membership models,
into a \code{\link[base]{matrix}}. The data.frame needs to contain (a) columns with membership IDs
(e.g. first row of which might be \code{2, 3, 5, 6, 0, 0}) and (b) columns containing weights
(e.g. first row of which might be \code{0.25, 0.25, 0.25, 0.25, 0, 0}; in this example the first row of
resulting matrix would be \code{0, 1, 1, 0, 1, 1}).
}
\author{
Zhang, Z., Charlton, C.M.J., Parker, R.M.A., Leckie, G., and Browne,
W.J. (2015) Centre for Multilevel Modelling, University of Bristol, U.K.
}
\seealso{
\code{\link{matrix2df}}
}

