
R version 2.15.0 (2012-03-30)
Copyright (C) 2012 The R Foundation for Statistical Computing
ISBN 3-900051-07-0
Platform: x86_64-unknown-linux-gnu (64-bit)

R is free software and comes with ABSOLUTELY NO WARRANTY.
You are welcome to redistribute it under certain conditions.
Type 'license()' or 'licence()' for distribution details.

R is a collaborative project with many contributors.
Type 'contributors()' for more information and
'citation()' on how to cite R or R packages in publications.

Type 'demo()' for some demos, 'help()' for on-line help, or
'help.start()' for an HTML browser interface to help.
Type 'q()' to quit R.

> #dyn.load("../src/cuba.so");source("../R/divonne.R");source("../R/commoncuba.R")
> library("R2Cuba")
> # Test de peakfinder
> # +++++++++++++++++++++++++++++++
> NDIM <- 3
> NCOMP <- 1
> NMAX <- 4
> integrand <- function(arg, phase) {
+   x <- arg[1]
+   y <- arg[2]
+   z <- arg[3]
+ # cat("PHASE", phase)
+   ff <- sin(x)*cos(y)*exp(z);
+ return(ff)
+ } # fin integrand
> 
> peakf <- function(bounds) {
+ #  print(bounds)
+   x <- matrix(0, ncol=NMAX, nrow=NDIM)
+    pas <- 1/(NMAX-1)
+    # 1ier point
+    x[,1] <- rep(0, NDIM)
+    # Les autres points
+    for (i in 2:NMAX) {
+       x[,i] <- x[,(i-1)] + pas
+     }
+   return(x)
+ } #end peakf
> 
> print(divonne(NDIM, NCOMP, integrand, flags=list(verbose=0) , peakfinder=peakf, nextra=NMAX))
integral: 0.6646195 (+-0.00064)
nregions: 14; number of evaluations:  3136; probability:  1.110223e-16 
> 
> 
> # -----------------------------------------------------------
> # Essai en dplacant les bornes
> integrand2 <- function(arg,phase, a) {
+   x <- arg[1]
+   y <- arg[2]
+   z <- arg[3]
+   ff <- sin(x-3)*cos(y-2)*exp(z-1);
+ return(ff)
+ } # End integrand2
> 
> peakf <- function(bounds) {
+ #  print(bounds)
+    x <- matrix(0, ncol=NMAX, nrow=NDIM)
+    pas <- 1/(NMAX-1)
+    # 1ier point
+    x[,1] <- c(3,2,1)
+    # Les autres points
+    for (i in 2:NMAX) {
+       x[,i] <- x[,(i-1)] + pas
+     }
+    
+   return(x)
+ } #end peakf
> 
> print(divonne(NDIM, NCOMP, integrand2, lower=c(3,2,1), upper=c(4,3,2),
+                flags=list(verbose=0) ,
+                 peakfinder=peakf, nextra=NMAX))
integral: 0.6646195 (+-0.00064)
nregions: 14; number of evaluations:  3136; probability:  1.110223e-16 
> 
>   
> 
> proc.time()
   user  system elapsed 
  0.197   0.015   0.204 
