% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_parsers.R
\name{parse_data}
\alias{parse_data}
\title{Parse raw plate reader data and convert it to a format compatible with QurvE}
\usage{
parse_data(
  data.file = NULL,
  map.file = NULL,
  software = c("Gen5", "Gen6", "Biolector", "Chi.Bio", "GrowthProfiler", "Tecan",
    "VictorNivo", "VictorX3"),
  convert.time = NULL,
  sheet.data = 1,
  sheet.map = 1,
  csvsep.data = ";",
  dec.data = ".",
  csvsep.map = ";",
  dec.map = ".",
  subtract.blank = TRUE,
  calib.growth = NULL,
  calib.fl = NULL,
  calib.fl2 = NULL,
  fl.normtype = c("growth", "fl2")
)
}
\arguments{
\item{data.file}{(Character) A table file with extension '.xlsx', '.xls', '.csv', '.tsv', or '.txt' containing raw plate reader (or similar device) data.}

\item{map.file}{(Character) A table file in column format with extension '.xlsx', '.xls', '.csv', '.tsv', or '.txt'  with 'well', 'ID', 'replicate', and 'concentration' in the first row. Used to assign sample information to wells in a plate.}

\item{software}{(Character) The name of the software/device used to export the plate reader data.}

\item{convert.time}{(\code{NULL} or string) Convert time values with a formula provided in the form \code{'y = function(x)'}.
For example: \code{convert.time = 'y = 24 * x'}}

\item{sheet.data, sheet.map}{(Numeric or Character) Number or name of the sheets in XLS or XLSX files containing experimental data or mapping information, respectively (\emph{optional}).}

\item{csvsep.data, csvsep.map}{(Character) separator used in CSV data files (ignored for other file types).  Default: \code{";"}}

\item{dec.data, dec.map}{(Character) decimal separator used in CSV, TSV or TXT files with measurements and mapping information, respectively.}

\item{subtract.blank}{(Logical) Shall blank values be subtracted from values within the same experiment (\link{TRUE}, the default) or not (\link{FALSE}).}

\item{calib.growth, calib.fl, calib.fl2}{(Character or \code{NULL}) Provide an equation in the form 'y = function(x)' (for example: 'y = x^2 * 0.3 - 0.5') to convert growth and fluorescence values. This can be used to, e.g., convert plate reader absorbance values into \ifelse{html}{\out{OD<sub>600</sub>}}{\eqn{OD_{600}}} or fluorescence intensity into molecule concentrations.
Caution!: When utilizing calibration, carefully consider whether or not blanks were subtracted to determine the calibration before selecting the input \code{subtract.blank = TRUE}.}

\item{fl.normtype}{(Character string) Normalize fluorescence values by either diving by \code{'growth'} or by fluorescence2 values (\code{'fl2'}).}
}
\value{
A \code{grodata} object suitable to run \code{\link{growth.workflow}}. See \code{\link{read_data}} for its structure.
}
\description{
\code{parse_data} takes a raw export file from a plate reader experiment (or similar device), extracts relevant information and parses it into the format required to run \code{\link{growth.workflow}}. If more than one read type is found the user is prompted to assign the correct reads to \code{growth} or \code{fluorescence}.
}
\details{
Metadata provided as \code{map.file} needs to have the following layout:
\figure{mapping-layout.png}
}
\examples{
if(interactive()){
grodata <- parse_data(data.file = system.file("fluorescence_test_Gen5.xlsx", package = "QurvE"),
                      sheet.data = 1,
                      map.file = system.file("fluorescence_test_Gen5.xlsx", package = "QurvE"),
                      sheet.map = "mapping",
                      software = "Gen5",
                      convert.time = "y = x * 24", # convert days to hours
                      calib.growth = "y = x * 3.058") # convert absorbance to OD values
}
}
