% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QuantumCat.R
\name{Multitest}
\alias{Multitest}
\title{Multiple testing}
\usage{
Multitest(number_of_tests, number_of_samples = 2, ploidy = 2,
  Sample_name = "Multitest", depth = 100, number_of_mutations = 150,
  number_of_clones = NULL, plot_results = T, save_Cell = F,
  preclustering = T, contamination = NULL, nclone_range = 2:5,
  maxit = 1, epsilon = 5 * (10^(-3)), ncores = 1)
}
\arguments{
\item{number_of_tests}{The number of times the QuantumCat function should be called}

\item{number_of_samples}{The number of samples on which the data should be simulated. Default is 2.}

\item{ploidy}{The general ploidy of the tumor. Default is 2.}

\item{Sample_name}{Name of the folder which will be created to save the data}

\item{depth}{The depth of sequencing (does not account for contamination). Default is 100x}

\item{number_of_mutations}{The total number of observed number of mutations (across all clones)}

\item{number_of_clones}{The wanted number of observable clones (meaning bearing at least 1 mutation)}

\item{plot_results}{Should the intermediate results be plotted and saved? Default is TRUE}

\item{save_Cell}{Should the dataframe with the cellularities be saved? Default is FALSE}

\item{preclustering}{Should the data be pre-clustered by k-means?}

\item{contamination}{A numeric vector indicating the fraction of normal cells in each sample.}

\item{nclone_range}{Range of values tested for the maximum likelihood}

\item{maxit}{Number of trials different initial conditions to be used to evaluate the mximum likelihood}

\item{epsilon}{The stop value of the EM algorithm}

\item{ncores}{Number of cores to be used for the optimization research}
}
\description{
Generates multiple data with the QuantumCat function, and assesses the clustering algorithm (output)
}
\examples{
\dontrun{
print("Tests multiple conditions of data generation...")
print("... and gives information on the clustering quality")
Multitest(number_of_tests=1,Sample_name="Example",ploidy="AB",
number_of_clones=2,plot_results=FALSE,depth=500,number_of_mutations=10)
}
}
\keyword{Data}
\keyword{generation}
\keyword{phylogeny}

