% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fmx_constraint.R
\name{fmx_constraint}
\alias{fmx_constraint}
\title{Parameter Constraint(s) of Mixture Distribution}
\usage{
fmx_constraint(
  dist,
  distname = dist@distname,
  K = dim(dist@pars)[1L],
  pars = dist@pars
)
}
\arguments{
\item{dist}{(optional) \linkS4class{fmx} object}

\item{distname}{\link[base]{character} scalar, name of distribution (see \linkS4class{fmx}),
default value determined by \code{dist}}

\item{K}{\link[base]{integer} scalar, number of components,
default value determined by \code{dist}}

\item{pars}{\link[base]{double} \link[base]{matrix},
distribution parameters of a finite mixture distribution (see \linkS4class{fmx}),
default value determined by \code{dist}}
}
\value{
\link{fmx_constraint} returns the indices of internal parameters
(only applicable to Tukey's \eqn{g}-&-\eqn{h} mixture distribution, yet) to be constrained,
based on the input \linkS4class{fmx} object \code{dist}.
}
\description{
Determine the parameter constraint(s) of a finite mixture distribution \linkS4class{fmx},
either by the value of parameters of such mixture distribution,
or by a user-specified string.
}
\examples{
(d0 = fmx('GH', A = c(1,4), g = c(.2,.1), h = c(.05,.1), w = c(1,1)))
(c0 = fmx_constraint(d0))
stopifnot(identical(c0, user_constraint(character(), distname = 'GH', K = 2L)))

(d1 = fmx('GH', A = c(1,4), g = c(.2,0), h = c(0,.1), w = c(1,1)))
(c1 = fmx_constraint(d1))
stopifnot(identical(c1, user_constraint(c('g2', 'h1'), distname = 'GH', K = 2L)))

(d2 = fmx('GH', A = c(1,4), g = c(.2,0), h = c(.15,.1), w = c(1,1)))
(c2 = fmx_constraint(d2))
stopifnot(identical(c2, user_constraint('g2', distname = 'GH', K = 2L)))

}
