% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QLMDe.R
\name{QLMDe}
\alias{QLMDe}
\title{Quantile Least Mahalanobis Distance estimates}
\usage{
QLMDe(
  x,
  distname = c("norm", "GH"),
  K,
  data.name = deparse1(substitute(x)),
  constraint = character(),
  p = QLMDp(obs = x),
  init = clust_fmx(x, distname = distname, K = K, constraint = constraint),
  tol = .Machine$double.eps^0.25,
  maxiter = 1000,
  ...
)
}
\arguments{
\item{x}{\code{\link[base]{numeric}} vector, the one-dimensional observations.}

\item{distname}{\code{\link[base]{character}} value, name of mixture distribution to be fitted.  Currently supports \code{'norm'} and \code{'GH'}.}

\item{K}{\code{\link[base]{integer}} value, number of components (e.g., must use \code{2L} instead of \code{2}).}

\item{data.name}{\code{\link[base]{character}} value, name for the observations for user-friendly print out.}

\item{constraint}{\code{\link[base]{character}} vector, parameters (\eqn{g} and/or \eqn{h} for Tukey's \eqn{g}-&-\eqn{h} mixture) to be set at 0.
See \code{\link{fmx_constraint}} for details.}

\item{p}{\code{\link[base]{numeric}} vector, percentiles at where the sample and theoretical quantiles are to be matched.
See \code{\link{QLMDp}} for details.}

\item{init}{\code{\linkS4class{fmx}} object, the initial values for the optimization algorithm, default provided by \code{\link{clust_fmx}}.}

\item{tol, maxiter}{see \code{\link{vuniroot2}}}

\item{...}{additional parameters of \code{\link[stats]{optim}}.}
}
\value{
An \code{\linkS4class{fmx_QLMDe}} object
}
\description{
The quantile least Mahalanobis distance algorithm (\code{\link{QLMDe}}) estimates the parameters of 
single-component or finite mixture distributions   
by minimizing the Mahalanobis distance between the vectors of sample and theoretical quantiles.
See \code{\link{QLMDp}} for the default selection of probabilities at which the sample and theoretical quantiles are compared.

The default initial values are based on trimmed \eqn{k}-means 
clustering with re-assignment provided by \code{\link{clust_fmx}}.
}
\details{
Quantile Least Mahalanobis Distance estimator (\code{\link{QLMDe}}) fits a single-component or finite mixture distribution 
by minimizing the Mahalanobis distance between
the theoretical and observed quantiles,
using the empirical quantile variance-covariance matrix \code{\link{quantile_vcov}}.
}
\examples{

\donttest{
# Generated from 1-component normal; start with 2-component normal fit
set.seed(1623); (y0n <- QLMDe(rnorm(1e3L), distname = 'norm', K = 2L))
StepK_fmx(y0n, test = 'logLik', Kmax = 2L) # one-component

# Generated from 2-component normal; start with 1-component normal fit
(d1 <- fmx('norm', mean = c(0, 1.5), sd = .5, w = c(.4, .6)))
set.seed(100); hist(x1 <- rfmx(n = 1e3L, dist = d1))
StepK_fmx(QLMDe(x1, distname = 'norm', K = 1L), test = 'logLik', Kmax = 2L)
}

(d2 = fmx('GH', A = c(1,6), B = 1.2, g = c(0,.3), h = c(.2,0), w = c(1,2)))
set.seed(3123); hist(x2 <- rfmx(n = 1e3L, dist = d2))
# using user-specified constraint
system.time(QLMDe(x2, distname = 'GH', K = 2L, constraint = c('g1', 'h2')))
\donttest{
# using Step_fmx
system.time(y2gh <- QLMDe(x2, distname = 'GH', K = 2L)) # ~2 secs
y2gh
ks_test(y2gh)
CvM_test(y2gh)
KL_dist(y2gh)
Step_fmx(y2gh, test = 'logLik') # identified true constraint :)
}

\donttest{
system.time(y1gh <- QLMDe(x2, distname = 'GH', K = 1L))
y1gh
StepK_fmx(y1gh, test = 'logLik', Kmax = 2L) # correct

#set.seed(1323); x3 <- rGH(n = 1e3L, g = .2, h = .1)
#system.time(tmp <- QLMDe(x3, distname = 'GH', K = 2L)) # ~2 secs
#StepK_fmx(tmp, Kmax = 2L) # very difficult to drop K ..
}

}
\seealso{
\code{\link[stats]{optim}}
}
