% Generated by roxygen2 (4.0.1): do not edit by hand
\name{QuantifQuantile.d}
\alias{QuantifQuantile.d}
\title{QuantifQuantile for general X}
\usage{
QuantifQuantile.d(X, Y, x, alpha = c(0.05, 0.25, 0.5, 0.75, 0.95),
  testN = c(35, 40, 45, 50, 55), p = 2, B = 50, tildeB = 20,
  same_N = TRUE, ncores = detectCores() - 1)
}
\arguments{
\item{X}{matrix of covariates.}

\item{Y}{vector of response variables.}

\item{x}{matrix of values for \code{x} in q_alpha(x).}

\item{alpha}{vector of order of the quantiles.}

\item{testN}{grid of values of \code{N} that will be tested.}

\item{p}{L_p norm optimal quantization.}

\item{B}{number of bootstrap replications for the bootstrap estimator.}

\item{tildeB}{number of bootstrap replications for the choice of \code{N}.}

\item{same_N}{whether to use the same value of \code{N} for each \code{alpha}
(\code{TRUE} by default).}

\item{ncores}{number of cores to use. Default is set to the number of cores
detected by R minus 1.}
}
\value{
An object of class \code{QuantifQuantile} which is a list with the
following components:

\item{hatq_opt}{A matrix containing the estimated conditional
quantiles. The number of columns is the number of considered values for \code{x}
and the number of rows the size of the order vector \code{alpha}. This object
 can also be returned using the usual \code{fitted.values} function.}

\item{N_opt}{Optimal selected value for \code{N}. An integer if
\code{same_N=TRUE} and a vector of integers of length \code{length(alpha)}
otherwise.}

\item{hatISE_N}{The matrix of estimated ISE provided by our selection
criterion for \code{N} before taking the mean according to \code{alpha}. The
number of columns is then \code{length(testN)} and the number of rows
\code{length(alpha)}.}

\item{hatq_N}{A 3-dimensional array containing the estimated
conditional quantiles for each considered value for \code{alpha}, \code{x} and \code{N}.}

\item{X}{The matrix of covariates.}

\item{Y}{The vector of response variables.}

\item{x}{The considered vector of values for \code{x} in q_alpha(x).}

\item{alpha}{The considered vector of order for the quantiles.}

\item{testN}{The considered grid of values for \code{N} that were tested.}
}
\description{
Estimation of conditional quantiles using optimal quantization
when \code{X} is d-dimensional.
}
\details{
\itemize{\item This function calculates estimated conditional
quantiles with a method based on optimal quantization for any dimension for
the covariate. The matrix of covariate \code{X} must have \code{d} rows
(dimension). For particular cases of \code{d} =1 or 2, it is strongly
recommended to use \code{\link{QuantifQuantile}} and
\code{\link{QuantifQuantile.d2}} respectively (computationally faster). The
argument \code{x} must also have \code{d} rows.
\item The criterion for selecting the number of quantizers is implemented in
this function. The user has to choose a grid \code{testN} of possible values
in which \code{N} will be selected. It actually minimizes some bootstrap
estimated version of the ISE (Integrated Squared Error). More precisely, for
\code{N} fixed, it calculates the sum according to \code{alpha} of
\code{hatISE_N} and then minimizes the resulting vector to get \code{N_opt}.
 However, the user can choose to select a different value of \code{N_opt} for
 each \code{alpha} by setting \code{same_N=FALSE}. In this case, the vector
 \code{N_opt} is obtained by minimizing each column of \code{hatISE_N}
 separately. The reason why \code{same_N=TRUE} by default is that taking
 \code{N_opt} according to \code{alpha} could provide crossing conditional
 quantile curves (rarely observed for not too close values of \code{alpha}).
 The function \code{\link{plot.QuantifQuantile}}
 illustrates the selection of \code{N_opt}. If the graph is not decreasing
 then increasing, the argument \code{testN} should be adapted.}
}
\examples{
\dontrun{
set.seed(644925)
n <- 500
X <- runif(n,-2,2)
Y <- X^2+rnorm(n)
x <- seq(min(X),max(X),length=100)
res <- QuantifQuantile.d(X,Y,x,testN=seq(15,35,by=5))
}
\dontrun{
set.seed(272422)
n <- 1000
X <- matrix(runif(n*2,-2,2),ncol=n)
Y <- apply(X^2,2,sum)+rnorm(n)
x1 <- seq(min(X[1,]),max(X[1,]),length=20)
x2 <- seq(min(X[2,]),max(X[2,]),length=20)
x <- matrix(c(rep(x1,20),sort(rep(x2,20))),nrow=nrow(X),byrow=TRUE)
res <- QuantifQuantile.d(X,Y,x,testN=seq(90,140,by=10),B=20,tildeB=15)
}
}
\references{
Charlier, I. and Paindaveine, D. and Saracco, J.,
\emph{Conditional quantile estimation through optimal quantization},
Journal of Statistical Planning and Inference, 2015 (156), 14-30.

Charlier, I. and Paindaveine, D. and Saracco, J.,
\emph{Conditional quantile estimator based on optimal
quantization: from theory to practice}, Submitted.
}
\seealso{
\code{\link{QuantifQuantile}} and \code{\link{QuantifQuantile.d2}}
for particular dimensions one and two.

\code{\link{plot.QuantifQuantile}},
\code{\link{print.QuantifQuantile}}, \code{\link{summary.QuantifQuantile}}
}

