% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Quandlapi.R
\name{quandl.api}
\alias{quandl.api}
\title{Executes Quandl API calls}
\usage{
quandl.api(path, http = c("GET", "PUT", "POST", "DELETE"),
  postdata = NULL, ...)
}
\arguments{
\item{path}{Path to api resource.}

\item{http}{Type of http request sent.}

\item{postdata}{A character or raw vector that is sent in a body.}

\item{...}{Named values that are interpretted as Quandl API parameters. Please see \url{https://www.quandl.com/docs/api}.}
}
\value{
Quandl API response.
}
\description{
Executes Quandl API calls
}
\details{
Set your \code{api_key} with \code{Quandl.api_key} function. For instructions on finding your api key go to \url{https://www.quandl.com/account/api}
}
\examples{
\dontrun{
quandldata = quandl.api(path="datasets/NSE/OIL", http="GET")
plot(quandldata[,1])
}
}
\seealso{
\code{\link{Quandl.api_key}}
}
