% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kb.test.R
\name{summary,kb.test-method}
\alias{summary,kb.test-method}
\title{Summarizing kernel-based quadratic distance results}
\usage{
\S4method{summary}{kb.test}(object)
}
\arguments{
\item{object}{Object of class \code{kb.test}}
}
\value{
List with the following components:
\itemize{
   \item \code{summary_tables} Table of computed descriptive statistics per variable (and per group if available).
   \item \code{test_results} Data frame with the results of the performed kernel-based quadratic distance test.
   \item \code{qqplots} Figure with qq-plots for each variable.
}
}
\description{
\code{summary} method for the class \code{kb.test}
}
\examples{
# create a kb.test object
x <- matrix(rnorm(100),ncol=2)
y <- matrix(rnorm(100),ncol=2)
# Normality test
my_test <- kb.test(x, h=0.5)
summary(my_test)

}
