% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SemiRegAND.R
\name{SemiQRegAND}
\alias{SemiQRegAND}
\alias{locpolAND_x0}
\alias{locpolAND}
\title{Semiparametric quantile regression in quantile-based asymmetric normal distributional settings.}
\usage{
locpolAND_x0(x, y, p1 = 1, p2 = 1, h, alpha = 0.5, x0, tol = 1e-08)

locpolAND(x, y, p1, p2, h, alpha, m = 101)

SemiQRegAND(beta, x, y, p1 = 1, p2 = 1, h, alpha = NULL, m = 101)
}
\arguments{
\item{x}{This a conditioning covariate.}

\item{y}{The is a response variable.}

\item{p1}{This is the order of the Taylor expansion for the location function (i.e.,\eqn{\mu(X)}) in local polynomial fitting technique. The default value is 1.}

\item{p2}{This is the order of the Taylor expansion for the log of scale function (i.e., \eqn{\ln[\phi(X)]}) in local polynomial fitting technique. The default value is 1.}

\item{h}{This is the bandwidth parameter \eqn{h}.}

\item{alpha}{This is the index parameter  \eqn{\alpha} of the quantile-based asymmetric normal density. The default value is 0.5 in the codes code \code{\link{locpolAND_x0}} and code \code{\link{locpolAND}}. The default value of \eqn{\alpha} is NULL in the code \code{\link{SemiQRegAND}}. In this case, \eqn{\alpha} will be estimated based on the residuals from local linear mean regression.}

\item{x0}{This is a grid-point \eqn{x_0} at which the function is to be estimated.}

\item{tol}{the desired accuracy. See details in \code{\link[stats]{optimize}}.}

\item{m}{This is the number of grid points at which the functions are to be evaluated. The default value is 101.}

\item{beta}{This is a specific probability for estimating \eqn{\beta}th quantile function.}
}
\value{
The code \code{\link{locpolAND_x0}} provides the realized value of the local maximum likelihood estimator of \eqn{\widehat{\theta}_{rj}(x_0)} for \eqn{(r\in \{1,2\}; j=1,2,...,p_r)} with the estimated approximate asymptotic bias and variance at the grind point \eqn{x_0} discussed in Gijbels et al. (2019c).

The code \code{\link{locpolAND}} provides the realized value of the local maximum likelihood estimator of \eqn{\widehat{\theta}_{r0}(x_0)} for \eqn{(r\in \{1,2\})} with the estimated approximate asymptotic bias and variance at all \eqn{m} grind points \eqn{x_0} discussed in Gijbels et al. (2019c).

The code \code{\link{SemiQRegAND}} provides the realized value of the \eqn{\beta}th conditional quantile estimator by using semiparametric quantile regression technique discussed in Gijbels et al. (2019b) and Gijbels et al. (2019c).
}
\description{
The local polynomial technique is used to estimate location and scale function of the quantile-based asymmetric normal distribution discussed in Gijbels et al. (2019c).
The semiparametric quantile estimation technique is used to estimate \eqn{\beta}th conditional quantile function in quantile-based asymmetric normal distributional setting discussed in Gijbels et al. (2019b) and Gijbels et al. (2019c).
}
\examples{
\donttest{
data(LocomotorPerfor)
x=log(LocomotorPerfor$Body_Mass)
y=log(LocomotorPerfor$MRRS)
h_ROT =  0.9030372
locpolAND_x0(x, y, p1=1,p2=1,h=h_ROT,alpha=0.50,x0=median(x))
}
\donttest{
data(LocomotorPerfor)
x=log(LocomotorPerfor$Body_Mass)
y=log(LocomotorPerfor$MRRS)
h_ROT =  0.9030372
locpolAND(x, y, p1=1,p2=1,h=h_ROT, alpha=0.50)
}
\donttest{
# Data
data(LocomotorPerfor)
x=log(LocomotorPerfor$Body_Mass)
y=log(LocomotorPerfor$MRRS)
h_ROT =  0.9030372
gridPoints=101
alpha= 0.5937
plot(x,y)
# location and scale functions estimation at the grid point x0
gridPoints=101
fit_AND <-locpolAND(x, y, p1=1,p2=1,h=h_ROT, alpha=alpha, m = gridPoints)
par(mgp=c(2,.4,0),mar=c(5,4,4,1)+0.01)

# For phi plot
plot(fit_AND$x0,exp(fit_AND$theta_20),ylab=expression(widehat(phi)(x[0])),
xlab="log(Body mass)",type="l",font.lab=2,cex.lab=1.5,
bty="l",cex.axis=1.5,lwd =3)

## For theta2 plot
plot(fit_AND$x0,fit_AND$theta_20,ylab=expression(bold(widehat(theta[2]))(x[0])),
xlab="log(Body mass)",type="l",col=c(1), lty=1, font.lab=1,cex.lab=1.5,
bty="l",cex.axis=1.3,lwd =3)



par(mgp=c(2.5, 1, 0),mar=c(5,4,4,1)+0.01)
# X11(width=7, height=7)
plot(x,y, ylim=c(0,4.5),xlab = "log(Body mass (kg))",
ylab = "log(Maximum relative running speed)",font.lab=1.5,
cex.lab=1.5,bty="l",pch=20,cex.axis=1.5)

lines(fit_AND$x0,fit_AND$theta_10, type='l',col=c(4),lty=6,lwd =3)
lines(fit_AND$x0,SemiQRegAND(beta=0.50,x, y,
p1=1,p2=1, h=h_ROT,alpha=alpha,m=gridPoints)$fit_beta_AND,
type='l',col=c(1),lty=5,lwd =3)
lines(fit_AND$x0,SemiQRegAND(beta=0.90,x, y,
p1=1,p2=1, h=h_ROT,alpha=alpha,m=gridPoints)$fit_beta_AND,type='l',col=c(14),lty=4,lwd =3)
lines(fit_AND$x0,SemiQRegAND(beta=0.10,x, y,
p1=1,p2=1, h=h_ROT,alpha=alpha,m=gridPoints)$fit_beta_AND,type='l',
col=c(19),lty=2,lwd =3)

legend("topright", legend = c(expression(beta==0.10),
                             expression(beta==0.50), expression(beta==0.5937),
                             expression(beta==0.90)), col = c(19,1,4,14), lty=c(2,5,6,4),
      adj = c(.07, 0.5),, inset = c(0.05, +0.01), lwd = 3,cex=1.2)

}
}
\references{
{
 Gijbels, I., Karim, R. and Verhasselt, A. (2019b). Quantile estimation in a generalized  asymmetric distributional setting. To appear in \emph{Springer Proceedings in Mathematics & Statistics, Proceedings of `SMSA 2019', the 14th Workshop on Stochastic Models, Statistics and their Application}, Dresden, Germany, in March 6--8, 2019. Editors: Ansgar Steland, Ewaryst Rafajlowicz, Ostap Okhrin.

Gijbels, I., Karim, R. and Verhasselt, A. (2019c).  Semiparametric quantile regression using quantile-based asymmetric family of densities. Manuscript.


}
}
