% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ALaD.R
\name{ALaD}
\alias{ALaD}
\alias{dALaD}
\alias{pALaD}
\alias{qALaD}
\alias{rALaD}
\title{Quantile-based asymmetric Laplace distribution}
\usage{
dALaD(y, mu, phi, alpha)

pALaD(q, mu, phi, alpha)

qALaD(beta, mu, phi, alpha)

rALaD(n, mu, phi, alpha)
}
\arguments{
\item{y, q}{These are each a vector of quantiles.}

\item{mu}{This is the location parameter \eqn{\mu}.}

\item{phi}{This is the scale parameter  \eqn{\phi}.}

\item{alpha}{This is the index parameter  \eqn{\alpha}.}

\item{beta}{This is a vector of probabilities.}

\item{n}{This is the number of observations, which must be a positive integer that has length 1.}
}
\value{
\code{\link{dALaD}} provides the density, \code{\link{pALaD}} provides the cumulative distribution function, \code{\link{qALaD}} provides the quantile function, and \code{\link{rALaD}} generates a random sample from the quantile-based asymmetric Laplace distribution.
The length of the result is determined by \eqn{n} for \code{\link{rALaD}}, and is the maximum of the lengths of the numerical arguments for the other functions.
}
\description{
Density, cumulative distribution function, quantile function and random sample generation
for the quantile-based asymmetric Laplace distribution (ALaD) discussed in Yu and Zhang (2005) and Gijbels et al. (2019a).
}
\examples{
# Density
rnum<-rnorm(100)
dALaD(y=rnum,mu=0,phi=1,alpha=.5)

# Distribution function
 pALaD(q=rnum,mu=0,phi=1,alpha=.5)

# Quantile function
beta<-c(0.25,0.5,0.75)
qALaD(beta=beta,mu=0,phi=1,alpha=.5)

# random sample generation
rALaD(n=100,mu=0,phi=1,alpha=.5)


}
\references{
{
 Gijbels, I., Karim, R. and Verhasselt, A. (2019a). On quantile-based asymmetric family of distributions: properties and inference. \emph{International Statistical Review}, \url{https://doi.org/10.1111/insr.12324}.


 Yu., K, and Zhang, J. (2005). A three-parameter asymmetric Laplace distribution and its extension. \emph{Communications in Statistics–Theory and Methods}, \bold{34}(9-10), 1867–1879.
}
}
\seealso{
\code{\link{dQBAD}},  \code{\link{pQBAD}},  \code{\link{qQBAD}},  \code{\link{rQBAD}}
}
