% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ALaD.R
\name{momentALaD}
\alias{momentALaD}
\alias{meanALaD}
\alias{varALaD}
\alias{skewALaD}
\alias{kurtALaD}
\title{Moments estimation for the quantile-based asymmetric Laplace distribution.}
\usage{
meanALaD(mu, phi, alpha)

varALaD(mu, phi, alpha)

skewALaD(alpha)

kurtALaD(alpha)

momentALaD(phi, alpha, r)
}
\arguments{
\item{mu}{This is the location parameter \eqn{\mu}.}

\item{phi}{This is the scale parameter  \eqn{\phi}.}

\item{alpha}{This is the index parameter  \eqn{\alpha}.}

\item{r}{This is a value which is used to calculate \eqn{r}th moment about \eqn{\mu}.}
}
\value{
\code{\link{meanALaD}} provides the mean, \code{\link{varALaD}} provides the variance, \code{\link{skewALaD}} provides the skewness, \code{\link{kurtALaD}} provides the kurtosis, and  \code{\link{momentALaD}} provides the \eqn{r}th moment about the location parameter \eqn{\mu} of the quantile-based asymmetric Laplace distribution.
}
\description{
Mean, variance, skewness, kurtosis and moments about the location parameter (i.e., \eqn{\alpha}th quantile) of the quantile-based asymmetric Laplace distribution studied in Gijbels et al. (2019a) useful for quantile regression with location parameter equal to \eqn{\mu}, scale parameter \eqn{\phi} and index parameter \eqn{\alpha}.
}
\examples{
# Example
meanALaD(mu=0,phi=1,alpha=0.5)
varALaD(mu=0,phi=1,alpha=0.5)
skewALaD(alpha=0.5)
kurtALaD(alpha=0.5)
momentALaD(phi=1,alpha=0.5,r=1)
}
\references{
{
 Gijbels, I., Karim, R. and Verhasselt, A. (2019a). On quantile-based asymmetric family of distributions: properties and inference. \emph{International Statistical Review}, to appear.
}
}
