% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/PyObjectTuple.R
\name{pyTuple}
\alias{pyTuple}
\title{Creates a virtual Python tuple}
\usage{
pyTuple(key, value, regFinalizer = FALSE)
}
\arguments{
\item{key}{a character string giving the name of the Python object.}

\item{value}{an optional value, allowed values are vectors, lists and NULL.}

\item{regFinalizer}{a logical indicating if a finalizer should be
be registered, the default value is TRUE.}
}
\description{
The function pyTuple creates a virtual Python object
             of type PythonInR_Tuple.
}
\details{
If no value is provided a virtual Python tuple for an existing
         Python object is created. If the value is NULL an empty
         virtual Python object for an empty tuple is created.
         If the value is a vector or tuple a new Python
         object based on the vector or list is created.
}
\examples{
\dontshow{PythonInR:::pyCranConnect()}
if ( pyIsConnected() ){
pyExec('myPyTuple = (1, 2, 5, "Hello R!")')
# create a virtual Python tuple for an existing tuple
myTuple <- pyTuple("myPyTuple")
myTuple[0]
tryCatch({myTuple[1] <- "should give an error since tuple are not mutable"},
         error = function(e) print(e))
myTuple
# create a new Python tuple and virtual tuple
newTuple <- pyTuple('myNewTuple', list(1:3, 'Hello Python'))
newTuple[1]
}
}

