% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_pupil_data.R
\name{plot.Pupil_window_data}
\alias{plot.Pupil_window_data}
\title{Pre-prepared plots of PupillometryR data}
\usage{
\method{plot}{Pupil_window_data}(
  x,
  pupil,
  windows = c(FALSE, TRUE),
  geom = c("raincloud", "violin", "boxplot"),
  ...
)
}
\arguments{
\item{x}{A Pupil_window_data dataframe}

\item{pupil}{Column name of pupil data to be plotted}

\item{windows}{Whether you want to include time windows in the plot - logical}

\item{geom}{violin plots or boxplots. The newest version adds raincloud plots using Ben Marwick's flat violin plot.}

\item{...}{Ignored}
}
\value{
A ggplot object
}
\description{
The plot functions are designed to run with just data and pupil selections,
with some additional options for fun with plotting. To see these plots,
you must first use create_window_data.
}
\examples{
Sdata <- make_pupillometryr_data(data = pupil_data,
                               subject = ID,
                               trial = Trial,
                               time = Time,
                               condition = Type)
regressed_data <- regress_data(data = Sdata, pupil1 = RPupil, pupil2 = LPupil)
mean_data <- calculate_mean_pupil_size(data = regressed_data,
pupil1 = RPupil, pupil2 = LPupil)
base_data <- baseline_data(data = mean_data, pupil = mean_pupil, start = 0, stop = 100)
window <- create_window_data(data = base_data,pupil = mean_pupil)
p <-plot(window, pupil = mean_pupil, windows = FALSE, geom = 'boxplot')
p

}
