% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_smoothed_data.R
\name{filter_data}
\alias{filter_data}
\title{Run a filter on the data to smooth it out.}
\usage{
filter_data(data, pupil, filter = c("median", "hanning", "lowpass"),
  degree = 11)
}
\arguments{
\item{data}{a PupillometryR dataframe}

\item{pupil}{column name for pupil data}

\item{filter}{option for filtering the data}

\item{degree}{filter degree}
}
\value{
filtered pupil data
}
\description{
filter_data allows three different options for filtering, a butterworth lowpass filter, a hanning filter, or
a median filter. You can also set the degree of this filter; we recommend a default of 11.
This filters on one pupil, it can be re-run on a second pupil if needed. Lowpass makes use of the
butterworth filter and filtfilt from package signal, median makes use of runmed.
}
\examples{
Sdata <- make_pupillometryr_data(data = pupil_data,
subject = ID,
trial = Trial,
time = Time,
condition = Type)
mean_data <- calculate_mean_pupil_size(data = Sdata,
pupil1 = RPupil, pupil2 = LPupil)
filtered_data <- filter_data(data = mean_data,
pupil = mean_pupil,
filter = 'hanning',
degree = 11)
}
