% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download.R
\name{retrieve_dgm_dataset}
\alias{retrieve_dgm_dataset}
\title{Retrieve a Pre-Simulated Condition and Repetition From a DGM}
\usage{
retrieve_dgm_dataset(dgm_name, condition_id, repetition_id = NULL)
}
\arguments{
\item{dgm_name}{Character string specifying the DGM type}

\item{condition_id}{which conditions should settings be returned for.}

\item{repetition_id}{Which repetition should be returned. The complete
condition can be returned by setting to either \code{NULL}.}
}
\value{
A data.frame
}
\description{
This function returns a pre-simulated dataset of a given repetition and
condition from a dgm. The pre-simulated datasets must be already stored
locally. See \link{download_dgm} function for more guidance.
}
\examples{
\donttest{
  # get condition 1, repetition 1
  retrieve_dgm_dataset("no_bias", condition_id = 1, repetition_id = 1)

  # get condition 1, all repetitions
  retrieve_dgm_dataset("no_bias", condition_id = 1)
}


}
