## #############################################################################################
## This file parses a PsyToolkit questionnaire for further R analyses
## Do not edit this file
## #############################################################################################

## note: cgi variables are not in the survey.txt file, they need to be
## extracted from the data if available

psytkParseSurvey = function( datadir = NA , surveyfilename = NA ){

    ## -- first check out where the datafile is -------------------------------

    psytkSurveyFile = ""
    if ( !is.na( datadir ) & is.na( surveyfilename ) ){
        psytkSurveyFile = file.path( datadir , "survey.txt" )
    }

    if ( is.na( datadir ) & !is.na( surveyfilename ) ){
        psytkSurveyFile = surveyfilename
    }


    if ( !is.na( datadir ) & !is.na( surveyfilename ) ){
        psytkSurveyFile = file.path( datadir , surveyfilename )
    }

    ## -- we will store the data dir in the survey object if available

    psytkDataDir = NA
    if ( !is.na( datadir ) ) { psytkDataDir = datadir }

    ## -- now read the file -------------------------------------------------

    tmp = readLines( psytkSurveyFile )

    ## -- now parse the file ------------------------------------------------

    tmp = tmp[!grepl("^#",tmp)] ## remove comment lines
    tmp = tmp[!grepl("j:",tmp)] ## remove j: lines
    tmp = tmp[!grepl("^----",tmp)] ## remove j: lines
    while( tmp[1] == "" ) { tmp=tmp[2:length(tmp)] } ## remove empty lines from top of file

    ## remove double empty lines between questions
    repeatedEmptyLine = c( F , tmp[2:length(tmp)]==tmp[1:(length(tmp)-1)] ) & tmp==""
    tmp = tmp[ !repeatedEmptyLine ]

    ## add one extra empty line to make parsing easier
    tmp = c( tmp , "" )

    ## now get ready to parse all the lines

    line=0

    psytkLabels      = NULL ## a vector of the Labels
    psytkSublabels   = NULL ## a vector of labels and subitems if needed (sometimes you need those for dot notation in some question types)

    psytkQuestions   = NULL ## a vector of the question texts (q:)
    psytkTypes       = NULL ##                 PsyToolkit question Types
    psytkSubtypes    = NULL ##                 PsyToolkit question Types matching sublabels

    psytkItemCount   = NULL ##                 Number of question items
    psytkExperiments = NULL ## list of experiment names included

    psytkItems       = NULL ## a vector of lists
    psytkAnswers     = list()
    currentLabel     = currentType = ""
    inQuestion       = F ## this means we are in a question starting with l: and ending with empty line
    inQuestionText   = F ## this means we are processing the q: line
    
    while( line < length( tmp )){
        line = line + 1 ## this helps to iterate through all questions
        current = tmp[line]

        ## ###############################################################################
        if ( current != "" ){

            words = strsplit( current , " ")[[1]]

            if ( words[1] == "l:" ){
                inQuestion = T ## needed, because with scale: you can also have scales with items etc

                ## init stuff
                currentLabel = words[2]
                currentType = NULL
                currentItems = NULL
                currentQuestion = "" # "" is a possibility as there are no q: for set and often not experiment
                psytkLabels = c( psytkLabels , currentLabel ) ## update the list of Labels
            }

            if ( inQuestion ){
                if ( words[1] == "t:" ){
                    currentType = words[2]
                    psytkTypes = c( psytkTypes , currentType ) ## update the list of types
                }

                if ( words[1] == "q:" ){
                    currentQuestion= substr(current,4,nchar(current))
                    inQuestionText = T
                }
                
                if ( words[1] == "-" ){ ## this means the items are starting
                    inQuestionText = F
                    if ( inQuestion == T ){
                        currentItems = c( currentItems , substr( current , 3 , nchar( current ) ))
                    }
                }
                
                if ( words[1] == "-" ){
                    inQuestionText = F
                    if ( currentType == "experiment" ){
                        psytkExperiments = c( psytkExperiments , words[ length( words ) ] ) ## there might be inline options as well
                    }
                }

                if ( words[1] != "l:" & words[1] != "t:" & words[1] != "o:" & words[1] != "-" & words[1] != "q:" & inQuestion == T ){
                    currentQuestion = paste( currentQuestion , current , sep="\n" )
                }
            }
        }else{
            inQuestionText = F
            ## we found the end of a question, so new question is coming
            ## now we can complete past question data
            if ( inQuestion == T ){

                psytkQuestions = c( psytkQuestions , currentQuestion )

                # in textbox/textline, for ease of coding, we can have question without spelling out the hyphen
                if ( is.null(currentItems) & ( currentType == "textline" | currentType == "textbox" ) ){ # for textline, we can have this with zero items, it should treat it as if there is one item
                    currentItems = "" # empty item, such as "what is your name, where we do not need the hyphen"
                }

                if ( is.null(currentItems) ){
                    psytkItemCount = c( psytkItemCount , 0 )
                    psytkItems = c( psytkItems , list(0) )
                }else{
                    psytkItems = c( psytkItems , list(currentItems) )
                    psytkItemCount = c( psytkItemCount , length( currentItems  ) )
                }

                inQuestion = F
            }
        }
    }

    ## now cylce through labels/types to create sublabels and subtypes
    for ( i in 1:length(psytkLabels) ){

        if ( psytkTypes[i] %in% c("textline","textbox","range","rank","check","scale") & psytkItemCount[i] > 1 ){

            ## now we need to create a subitem with .1, .2 etc for each item
            psytkSublabels = c( psytkSublabels , paste( psytkLabels[i] , 1:psytkItemCount[i] , sep="." ))
            psytkSubtypes  = c( psytkSubtypes , rep( psytkTypes[i] , psytkItemCount[i] ) )
        }else{
            psytkSublabels = c( psytkSublabels , psytkLabels[i] )
            psytkSubtypes  = c( psytkSubtypes , psytkTypes[i] )
        }

        
    }

    ## psytk is quickoverview
    psytkSurvey = data.frame(labels    = psytkLabels    ,
                             types     = psytkTypes     ,
                             questions = psytkQuestions ,
                             items     = psytkItemCount ,
                             notes     = rep("",length(psytkLabels) ))

    longoverview = data.frame( labels=psytkSublabels , types=psytkSubtypes )

    ## ##################################################################################
    ## helper statistical functions

    return( list(overview = psytkSurvey ,
                 datadir = psytkDataDir ,
                 experiments = psytkExperiments ,
                 psytkItems = psytkItems ,
                 longoverview = longoverview ) )
}
