% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01supporting_functions.r
\name{rawToUnsignedInt}
\alias{rawToUnsignedInt}
\title{Convert raw vector into a single unsigned integer value}
\usage{
rawToUnsignedInt(raw_dat)
}
\arguments{
\item{raw_dat}{A vector of class \code{raw} to be converted into an unsigned integer}
}
\value{
A single unsigned integer value based on the provided \code{raw} data
}
\description{
This function converts \code{raw} data into an unsigned integer
}
\details{
This function converts a vector of raw data into a single unsigned integer.
for conversion of raw data into a vector of unsigned integers [0,255] use
`\code{\link{as.integer}(x)}'. For an inverse of this function
see \code{\link{unsignedIntToRaw}}.
}
\examples{
## generate some raw data:
some.raw.data <- as.raw(c(0x01, 0x1e, 0x3f))

## convert raw data into an unsigned integer:
rawToUnsignedInt(some.raw.data)

## note the difference with
as.integer(some.raw.data)

}
\seealso{
Other raw.operations: 
\code{\link{as.raw}()},
\code{\link{nybbleToSignedInt}()},
\code{\link{nybble}()},
\code{\link{rawToCharNull}()},
\code{\link{rawToPTModule}()},
\code{\link{rawToSignedInt}()},
\code{\link{signedIntToNybble}()},
\code{\link{signedIntToRaw}()},
\code{\link{unsignedIntToRaw}()}

Other integer.operations: 
\code{\link{nybbleToSignedInt}()},
\code{\link{nybble}()},
\code{\link{rawToSignedInt}()},
\code{\link{signedIntToNybble}()},
\code{\link{signedIntToRaw}()},
\code{\link{unsignedIntToRaw}()},
\code{\link{waveform}()}
}
\author{
Pepijn de Vries
}
\concept{integer.operations}
\concept{raw.operations}
