% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02PTCell.r, R/03PTTrack.r, R/04PTPattern.r, R/05PTSample.r, R/06PTModule.r
\docType{methods}
\name{print}
\alias{print}
\alias{print,PTCell-method}
\alias{print,PTModule-method}
\alias{print,PTPattern-method}
\alias{print,PTSample-method}
\alias{print,PTTrack-method}
\title{Print ProTrackR objects}
\usage{
\S4method{print}{PTCell}(x, ...)

\S4method{print}{PTTrack}(x, ...)

\S4method{print}{PTPattern}(x, ...)

\S4method{print}{PTSample}(x, ...)

\S4method{print}{PTModule}(x, ...)
}
\arguments{
\item{x}{Either a \code{\link{PTModule}}, \code{\link{PTPattern}},
\code{\link{PTTrack}}, \code{\link{PTCell}} or
\code{\link{PTSample}} object.}

\item{...}{further arguments passed to or from other methods}
}
\value{
Depending on the class of \code{x}, returns either nothing
(\code{NULL}) or a \code{character} representation
of object \code{x}.
}
\description{
A method to print \code{\link{ProTrackR}} S4 class objects.
}
\examples{
data("mod.intro")
print(mod.intro)
print(PTPattern(mod.intro, 1))
print(PTTrack(mod.intro, 1, 1))
print(PTCell   (mod.intro, 1, 1, 1))
print(PTSample (mod.intro, 1))
}
\author{
Pepijn de Vries
}

